import { CreateLibraryDto, LibraryResponseDto, LibraryStatsResponseDto, UpdateLibraryDto, ValidateLibraryDto, ValidateLibraryResponseDto } from 'src/dtos/library.dto';
import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class LibraryService extends BaseService {
    private watchLibraries;
    private lock;
    private watchers;
    onConfigInit({ newConfig: { library: { watch, scan }, }, }: ArgOf<'config.init'>): Promise<void>;
    onConfigUpdate({ newConfig: { library } }: ArgOf<'config.update'>): Promise<void>;
    private watch;
    unwatch(id: string): Promise<void>;
    onShutdown(): Promise<void>;
    private unwatchAll;
    watchAll(): Promise<false | undefined>;
    getStatistics(id: string): Promise<LibraryStatsResponseDto>;
    get(id: string): Promise<LibraryResponseDto>;
    getAll(): Promise<LibraryResponseDto[]>;
    handleQueueCleanup(): Promise<JobStatus>;
    create(dto: CreateLibraryDto): Promise<LibraryResponseDto>;
    handleSyncFiles(job: JobOf<JobName.LIBRARY_SYNC_FILES>): Promise<JobStatus>;
    private validateImportPath;
    validate(id: string, dto: ValidateLibraryDto): Promise<ValidateLibraryResponseDto>;
    update(id: string, dto: UpdateLibraryDto): Promise<LibraryResponseDto>;
    delete(id: string): Promise<void>;
    handleDeleteLibrary(job: JobOf<JobName.LIBRARY_DELETE>): Promise<JobStatus>;
    private processEntity;
    queuePostSyncJobs(assetIds: string[]): Promise<void>;
    queueScan(id: string): Promise<void>;
    queueScanAll(): Promise<void>;
    handleQueueScanAll(): Promise<JobStatus>;
    handleSyncAssets(job: JobOf<JobName.LIBRARY_SYNC_ASSETS>): Promise<JobStatus>;
    private checkExistingAsset;
    handleQueueSyncFiles(job: JobOf<JobName.LIBRARY_QUEUE_SYNC_FILES>): Promise<JobStatus>;
    handleAssetRemoval(job: JobOf<JobName.LIBRARY_ASSET_REMOVAL>): Promise<JobStatus>;
    handleQueueSyncAssets(job: JobOf<JobName.LIBRARY_QUEUE_SYNC_ASSETS>): Promise<JobStatus>;
    private findOrFail;
}
