import { ClassConstructor } from 'class-transformer';
import { AllJobStatusResponseDto, JobCommandDto, JobCreateDto, JobStatusDto } from 'src/dtos/job.dto';
import { QueueName } from 'src/enum';
import { ArgOf, ArgsOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class JobService extends BaseService {
    private services;
    onConfigInit({ newConfig: config }: ArgOf<'config.init'>): void;
    onConfigUpdate({ newConfig: config }: ArgOf<'config.update'>): void;
    onBootstrap(): void;
    setServices(services: ClassConstructor<unknown>[]): void;
    create(dto: JobCreateDto): Promise<void>;
    handleCommand(queueName: QueueName, dto: JobCommandDto): Promise<JobStatusDto>;
    getJobStatus(queueName: QueueName): Promise<JobStatusDto>;
    getAllJobsStatus(): Promise<AllJobStatusResponseDto>;
    private start;
    onJobStart(...[queueName, job]: ArgsOf<'job.start'>): Promise<void>;
    private isConcurrentQueue;
    handleNightlyJobs(): Promise<void>;
    private onDone;
}
