"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DuplicateService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../constants");
const decorators_1 = require("../decorators");
const asset_response_dto_1 = require("../dtos/asset-response.dto");
const enum_1 = require("../enum");
const asset_repository_1 = require("../repositories/asset.repository");
const base_service_1 = require("./base.service");
const asset_util_1 = require("../utils/asset.util");
const misc_1 = require("../utils/misc");
const pagination_1 = require("../utils/pagination");
let DuplicateService = class DuplicateService extends base_service_1.BaseService {
    async getDuplicates(auth) {
        const duplicates = await this.assetRepository.getDuplicates(auth.user.id);
        return duplicates.map(({ duplicateId, assets }) => ({
            duplicateId,
            assets: assets.map((asset) => (0, asset_response_dto_1.mapAsset)(asset, { auth })),
        }));
    }
    async handleQueueSearchDuplicates({ force }) {
        const { machineLearning } = await this.getConfig({ withCache: false });
        if (!(0, misc_1.isDuplicateDetectionEnabled)(machineLearning)) {
            return enum_1.JobStatus.SKIPPED;
        }
        const assetPagination = (0, pagination_1.usePagination)(constants_1.JOBS_ASSET_PAGINATION_SIZE, (pagination) => {
            return force
                ? this.assetRepository.getAll(pagination, { isVisible: true })
                : this.assetRepository.getWithout(pagination, asset_repository_1.WithoutProperty.DUPLICATE);
        });
        for await (const assets of assetPagination) {
            await this.jobRepository.queueAll(assets.map((asset) => ({ name: enum_1.JobName.DUPLICATE_DETECTION, data: { id: asset.id } })));
        }
        return enum_1.JobStatus.SUCCESS;
    }
    async handleSearchDuplicates({ id }) {
        const { machineLearning } = await this.getConfig({ withCache: true });
        if (!(0, misc_1.isDuplicateDetectionEnabled)(machineLearning)) {
            return enum_1.JobStatus.SKIPPED;
        }
        const asset = await this.assetJobRepository.getForSearchDuplicatesJob(id);
        if (!asset) {
            this.logger.error(`Asset ${id} not found`);
            return enum_1.JobStatus.FAILED;
        }
        if (asset.stackId) {
            this.logger.debug(`Asset ${id} is part of a stack, skipping`);
            return enum_1.JobStatus.SKIPPED;
        }
        if (!asset.isVisible) {
            this.logger.debug(`Asset ${id} is not visible, skipping`);
            return enum_1.JobStatus.SKIPPED;
        }
        const previewFile = (0, asset_util_1.getAssetFile)(asset.files || [], enum_1.AssetFileType.PREVIEW);
        if (!previewFile) {
            this.logger.warn(`Asset ${id} is missing preview image`);
            return enum_1.JobStatus.FAILED;
        }
        if (!asset.embedding) {
            this.logger.debug(`Asset ${id} is missing embedding`);
            return enum_1.JobStatus.FAILED;
        }
        const duplicateAssets = await this.searchRepository.searchDuplicates({
            assetId: asset.id,
            embedding: asset.embedding,
            maxDistance: machineLearning.duplicateDetection.maxDistance,
            type: asset.type,
            userIds: [asset.ownerId],
        });
        let assetIds = [asset.id];
        if (duplicateAssets.length > 0) {
            this.logger.debug(`Found ${duplicateAssets.length} duplicate${duplicateAssets.length === 1 ? '' : 's'} for asset ${asset.id}`);
            assetIds = await this.updateDuplicates(asset, duplicateAssets);
        }
        else if (asset.duplicateId) {
            this.logger.debug(`No duplicates found for asset ${asset.id}, removing duplicateId`);
            await this.assetRepository.update({ id: asset.id, duplicateId: null });
        }
        const duplicatesDetectedAt = new Date();
        await this.assetRepository.upsertJobStatus(...assetIds.map((assetId) => ({ assetId, duplicatesDetectedAt })));
        return enum_1.JobStatus.SUCCESS;
    }
    async updateDuplicates(asset, duplicateAssets) {
        const duplicateIds = [
            ...new Set(duplicateAssets
                .filter((asset) => !!asset.duplicateId)
                .map((duplicate) => duplicate.duplicateId)),
        ];
        const targetDuplicateId = asset.duplicateId ?? duplicateIds.shift() ?? this.cryptoRepository.randomUUID();
        const assetIdsToUpdate = duplicateAssets
            .filter((asset) => asset.duplicateId !== targetDuplicateId)
            .map((duplicate) => duplicate.assetId);
        assetIdsToUpdate.push(asset.id);
        await this.assetRepository.updateDuplicates({ targetDuplicateId, assetIds: assetIdsToUpdate, duplicateIds });
        return assetIdsToUpdate;
    }
};
exports.DuplicateService = DuplicateService;
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.QUEUE_DUPLICATE_DETECTION, queue: enum_1.QueueName.DUPLICATE_DETECTION }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], DuplicateService.prototype, "handleQueueSearchDuplicates", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.DUPLICATE_DETECTION, queue: enum_1.QueueName.DUPLICATE_DETECTION }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], DuplicateService.prototype, "handleSearchDuplicates", null);
exports.DuplicateService = DuplicateService = __decorate([
    (0, common_1.Injectable)()
], DuplicateService);
//# sourceMappingURL=duplicate.service.js.map