import { UserAdminResponseDto } from 'src/dtos/user.dto';
import { BaseService } from 'src/services/base.service';
export declare class CliService extends BaseService {
    listUsers(): Promise<UserAdminResponseDto[]>;
    resetAdminPassword(ask: (admin: UserAdminResponseDto) => Promise<string | undefined>): Promise<{
        admin: {
            name: string;
            id: string;
            email: string;
            updatedAt: Date;
            deletedAt: Date | null;
            createdAt: Date;
            status: import("../enum").UserStatus;
            quotaSizeInBytes: number | null;
            profileImagePath: string;
            isAdmin: boolean;
            shouldChangePassword: boolean;
            oauthId: string;
            storageLabel: string | null;
            quotaUsageInBytes: number;
            profileChangedAt: Date;
            metadata: {
                key: import("../enum").UserMetadataKey;
                value: {
                    folders?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    memories?: {
                        enabled?: boolean | undefined;
                    } | undefined;
                    people?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    ratings?: {
                        enabled?: boolean | undefined;
                    } | undefined;
                    sharedLinks?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    tags?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    avatar?: {
                        color?: import("../enum").UserAvatarColor | undefined;
                    } | undefined;
                    emailNotifications?: {
                        enabled?: boolean | undefined;
                        albumInvite?: boolean | undefined;
                        albumUpdate?: boolean | undefined;
                    } | undefined;
                    download?: {
                        archiveSize?: number | undefined;
                        includeEmbeddedVideos?: boolean | undefined;
                    } | undefined;
                    purchase?: {
                        showSupportBadge?: boolean | undefined;
                        hideBuyButtonUntil?: string | undefined;
                    } | undefined;
                } | {
                    licenseKey: string;
                    activationKey: string;
                    activatedAt: string;
                };
            }[];
        };
        password: string;
        provided: boolean;
    }>;
    disablePasswordLogin(): Promise<void>;
    enablePasswordLogin(): Promise<void>;
    disableOAuthLogin(): Promise<void>;
    enableOAuthLogin(): Promise<void>;
    cleanup(): Promise<void>;
}
