import { AssetResponseDto, MemoryLaneResponseDto, SanitizedAssetResponseDto } from 'src/dtos/asset-response.dto';
import { AssetBulkDeleteDto, AssetBulkUpdateDto, AssetJobsDto, AssetStatsDto, UpdateAssetDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { MemoryLaneDto } from 'src/dtos/search.dto';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class AssetService extends BaseService {
    getMemoryLane(auth: AuthDto, dto: MemoryLaneDto): Promise<MemoryLaneResponseDto[]>;
    getStatistics(auth: AuthDto, dto: AssetStatsDto): Promise<import("src/dtos/asset.dto").AssetStatsResponseDto>;
    getRandom(auth: AuthDto, count: number): Promise<AssetResponseDto[]>;
    getUserAssetsByDeviceId(auth: AuthDto, deviceId: string): Promise<string[]>;
    get(auth: AuthDto, id: string): Promise<AssetResponseDto | SanitizedAssetResponseDto>;
    update(auth: AuthDto, id: string, dto: UpdateAssetDto): Promise<AssetResponseDto>;
    updateAll(auth: AuthDto, dto: AssetBulkUpdateDto): Promise<void>;
    handleAssetDeletionCheck(): Promise<JobStatus>;
    handleAssetDeletion(job: JobOf<JobName.ASSET_DELETION>): Promise<JobStatus>;
    deleteAll(auth: AuthDto, dto: AssetBulkDeleteDto): Promise<void>;
    run(auth: AuthDto, dto: AssetJobsDto): Promise<void>;
    private findOrFail;
    private updateMetadata;
}
