import { AddUsersDto, AlbumInfoDto, AlbumResponseDto, AlbumStatisticsResponseDto, CreateAlbumDto, GetAlbumsDto, UpdateAlbumDto, UpdateAlbumUserDto } from 'src/dtos/album.dto';
import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { BaseService } from 'src/services/base.service';
export declare class AlbumService extends BaseService {
    getStatistics(auth: AuthDto): Promise<AlbumStatisticsResponseDto>;
    getAll({ user: { id: ownerId } }: AuthDto, { assetId, shared }: GetAlbumsDto): Promise<AlbumResponseDto[]>;
    get(auth: AuthDto, id: string, dto: AlbumInfoDto): Promise<AlbumResponseDto>;
    create(auth: AuthDto, dto: CreateAlbumDto): Promise<AlbumResponseDto>;
    update(auth: AuthDto, id: string, dto: UpdateAlbumDto): Promise<AlbumResponseDto>;
    delete(auth: AuthDto, id: string): Promise<void>;
    addAssets(auth: AuthDto, id: string, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    removeAssets(auth: AuthDto, id: string, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    addUsers(auth: AuthDto, id: string, { albumUsers }: AddUsersDto): Promise<AlbumResponseDto>;
    removeUser(auth: AuthDto, id: string, userId: string | 'me'): Promise<void>;
    updateUser(auth: AuthDto, id: string, userId: string, dto: UpdateAlbumUserDto): Promise<void>;
    private findOrFail;
}
