"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActivityService = void 0;
const common_1 = require("@nestjs/common");
const activity_dto_1 = require("../dtos/activity.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
let ActivityService = class ActivityService extends base_service_1.BaseService {
    async getAll(auth, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.ALBUM_READ, ids: [dto.albumId] });
        const activities = await this.activityRepository.search({
            userId: dto.userId,
            albumId: dto.albumId,
            assetId: dto.level === activity_dto_1.ReactionLevel.ALBUM ? null : dto.assetId,
            isLiked: dto.type && dto.type === activity_dto_1.ReactionType.LIKE,
        });
        return activities.map((activity) => (0, activity_dto_1.mapActivity)(activity));
    }
    async getStatistics(auth, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.ALBUM_READ, ids: [dto.albumId] });
        return { comments: await this.activityRepository.getStatistics({ albumId: dto.albumId, assetId: dto.assetId }) };
    }
    async create(auth, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.ACTIVITY_CREATE, ids: [dto.albumId] });
        const common = {
            userId: auth.user.id,
            assetId: dto.assetId,
            albumId: dto.albumId,
        };
        let activity;
        let duplicate = false;
        if (dto.type === activity_dto_1.ReactionType.LIKE) {
            delete dto.comment;
            [activity] = await this.activityRepository.search({
                ...common,
                assetId: dto.assetId ?? null,
                isLiked: true,
            });
            duplicate = !!activity;
        }
        if (!activity) {
            activity = await this.activityRepository.create({
                ...common,
                isLiked: dto.type === activity_dto_1.ReactionType.LIKE,
                comment: dto.comment,
            });
        }
        return { duplicate, value: (0, activity_dto_1.mapActivity)(activity) };
    }
    async delete(auth, id) {
        await this.requireAccess({ auth, permission: enum_1.Permission.ACTIVITY_DELETE, ids: [id] });
        await this.activityRepository.delete(id);
    }
};
exports.ActivityService = ActivityService;
exports.ActivityService = ActivityService = __decorate([
    (0, common_1.Injectable)()
], ActivityService);
//# sourceMappingURL=activity.service.js.map