"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserTable = void 0;
const decorators_1 = require("../../decorators");
const enum_1 = require("../../enum");
const functions_1 = require("../functions");
const sql_tools_1 = require("../../sql-tools");
let UserTable = class UserTable {
    id;
    email;
    password;
    createdAt;
    profileImagePath;
    isAdmin;
    shouldChangePassword;
    deletedAt;
    oauthId;
    updatedAt;
    storageLabel;
    name;
    quotaSizeInBytes;
    quotaUsageInBytes;
    status;
    profileChangedAt;
    updateId;
};
exports.UserTable = UserTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Object)
], UserTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.Column)({ unique: true }),
    __metadata("design:type", String)
], UserTable.prototype, "email", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: '' }),
    __metadata("design:type", Object)
], UserTable.prototype, "password", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Object)
], UserTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: '' }),
    __metadata("design:type", Object)
], UserTable.prototype, "profileImagePath", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Object)
], UserTable.prototype, "isAdmin", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Object)
], UserTable.prototype, "shouldChangePassword", void 0);
__decorate([
    (0, sql_tools_1.DeleteDateColumn)(),
    __metadata("design:type", Object)
], UserTable.prototype, "deletedAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: '' }),
    __metadata("design:type", Object)
], UserTable.prototype, "oauthId", void 0);
__decorate([
    (0, sql_tools_1.UpdateDateColumn)(),
    __metadata("design:type", Object)
], UserTable.prototype, "updatedAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ unique: true, nullable: true, default: null }),
    __metadata("design:type", Object)
], UserTable.prototype, "storageLabel", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: '' }),
    __metadata("design:type", Object)
], UserTable.prototype, "name", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'bigint', nullable: true }),
    __metadata("design:type", Object)
], UserTable.prototype, "quotaSizeInBytes", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'bigint', default: 0 }),
    __metadata("design:type", Object)
], UserTable.prototype, "quotaUsageInBytes", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'character varying', default: enum_1.UserStatus.ACTIVE }),
    __metadata("design:type", Object)
], UserTable.prototype, "status", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone', default: () => 'now()' }),
    __metadata("design:type", Object)
], UserTable.prototype, "profileChangedAt", void 0);
__decorate([
    (0, decorators_1.UpdateIdColumn)({ indexName: 'IDX_users_update_id' }),
    __metadata("design:type", Object)
], UserTable.prototype, "updateId", void 0);
exports.UserTable = UserTable = __decorate([
    (0, sql_tools_1.Table)('users'),
    (0, decorators_1.UpdatedAtTrigger)('users_updated_at'),
    (0, sql_tools_1.AfterDeleteTrigger)({
        name: 'users_delete_audit',
        scope: 'statement',
        function: functions_1.users_delete_audit,
        referencingOldTableAs: 'old',
        when: 'pg_trigger_depth() = 0',
    }),
    (0, sql_tools_1.Index)({ name: 'IDX_users_updated_at_asc_id_asc', columns: ['updatedAt', 'id'] })
], UserTable);
//# sourceMappingURL=user.table.js.map