import { ColumnType } from 'kysely';
import { UserStatus } from 'src/enum';
type Timestamp = ColumnType<Date, Date | string, Date | string>;
type Generated<T> = T extends ColumnType<infer S, infer I, infer U> ? ColumnType<S, I | undefined, U> : ColumnType<T, T | undefined, T>;
export declare class UserTable {
    id: Generated<string>;
    email: string;
    password: Generated<string>;
    createdAt: Generated<Timestamp>;
    profileImagePath: Generated<string>;
    isAdmin: Generated<boolean>;
    shouldChangePassword: Generated<boolean>;
    deletedAt: Timestamp | null;
    oauthId: Generated<string>;
    updatedAt: Generated<Timestamp>;
    storageLabel: string | null;
    name: Generated<string>;
    quotaSizeInBytes: ColumnType<number> | null;
    quotaUsageInBytes: Generated<ColumnType<number>>;
    status: Generated<UserStatus>;
    profileChangedAt: Generated<Timestamp>;
    updateId: Generated<string>;
}
export {};
