"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedLinkTable = void 0;
const enum_1 = require("../../enum");
const album_table_1 = require("./album.table");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
let SharedLinkTable = class SharedLinkTable {
    id;
    description;
    userId;
    key;
    type;
    createdAt;
    expiresAt;
    allowUpload;
    albumId;
    allowDownload;
    showExif;
    password;
};
exports.SharedLinkTable = SharedLinkTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", String)
], SharedLinkTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'character varying', nullable: true }),
    __metadata("design:type", Object)
], SharedLinkTable.prototype, "description", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE' }),
    __metadata("design:type", String)
], SharedLinkTable.prototype, "userId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'bytea', indexName: 'IDX_sharedlink_key' }),
    __metadata("design:type", Buffer)
], SharedLinkTable.prototype, "key", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], SharedLinkTable.prototype, "type", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], SharedLinkTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone', nullable: true }),
    __metadata("design:type", Object)
], SharedLinkTable.prototype, "expiresAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Boolean)
], SharedLinkTable.prototype, "allowUpload", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => album_table_1.AlbumTable, {
        nullable: true,
        onDelete: 'CASCADE',
        onUpdate: 'CASCADE',
        indexName: 'IDX_sharedlink_albumId',
    }),
    __metadata("design:type", String)
], SharedLinkTable.prototype, "albumId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], SharedLinkTable.prototype, "allowDownload", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], SharedLinkTable.prototype, "showExif", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'character varying', nullable: true }),
    __metadata("design:type", Object)
], SharedLinkTable.prototype, "password", void 0);
exports.SharedLinkTable = SharedLinkTable = __decorate([
    (0, sql_tools_1.Table)('shared_links'),
    (0, sql_tools_1.Unique)({ name: 'UQ_sharedlink_key', columns: ['key'] })
], SharedLinkTable);
//# sourceMappingURL=shared-link.table.js.map