"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetFaceTable = void 0;
const enum_1 = require("../../enum");
const enums_1 = require("../enums");
const asset_table_1 = require("./asset.table");
const person_table_1 = require("./person.table");
const sql_tools_1 = require("../../sql-tools");
let AssetFaceTable = class AssetFaceTable {
    assetId;
    personId;
    imageWidth;
    imageHeight;
    boundingBoxX1;
    boundingBoxY1;
    boundingBoxX2;
    boundingBoxY2;
    id;
    sourceType;
    deletedAt;
};
exports.AssetFaceTable = AssetFaceTable;
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => asset_table_1.AssetTable, {
        onDelete: 'CASCADE',
        onUpdate: 'CASCADE',
        index: false,
    }),
    __metadata("design:type", String)
], AssetFaceTable.prototype, "assetId", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => person_table_1.PersonTable, {
        onDelete: 'SET NULL',
        onUpdate: 'CASCADE',
        nullable: true,
        index: false,
    }),
    __metadata("design:type", Object)
], AssetFaceTable.prototype, "personId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: 0, type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceTable.prototype, "imageWidth", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: 0, type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceTable.prototype, "imageHeight", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: 0, type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceTable.prototype, "boundingBoxX1", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: 0, type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceTable.prototype, "boundingBoxY1", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: 0, type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceTable.prototype, "boundingBoxX2", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: 0, type: 'integer' }),
    __metadata("design:type", Number)
], AssetFaceTable.prototype, "boundingBoxY2", void 0);
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", String)
], AssetFaceTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: enum_1.SourceType.MACHINE_LEARNING, enum: enums_1.asset_face_source_type }),
    __metadata("design:type", String)
], AssetFaceTable.prototype, "sourceType", void 0);
__decorate([
    (0, sql_tools_1.DeleteDateColumn)(),
    __metadata("design:type", Object)
], AssetFaceTable.prototype, "deletedAt", void 0);
exports.AssetFaceTable = AssetFaceTable = __decorate([
    (0, sql_tools_1.Table)({ name: 'asset_faces' }),
    (0, sql_tools_1.Index)({ name: 'IDX_asset_faces_assetId_personId', columns: ['assetId', 'personId'] }),
    (0, sql_tools_1.Index)({ columns: ['personId', 'assetId'] })
], AssetFaceTable);
//# sourceMappingURL=asset-face.table.js.map