"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActivityTable = void 0;
const decorators_1 = require("../../decorators");
const album_table_1 = require("./album.table");
const asset_table_1 = require("./asset.table");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
let ActivityTable = class ActivityTable {
    id;
    createdAt;
    updatedAt;
    albumId;
    userId;
    assetId;
    comment;
    isLiked;
    updateId;
};
exports.ActivityTable = ActivityTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", String)
], ActivityTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], ActivityTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], ActivityTable.prototype, "updatedAt", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => album_table_1.AlbumTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE' }),
    __metadata("design:type", String)
], ActivityTable.prototype, "albumId", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE' }),
    __metadata("design:type", String)
], ActivityTable.prototype, "userId", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => asset_table_1.AssetTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE', nullable: true }),
    __metadata("design:type", Object)
], ActivityTable.prototype, "assetId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'text', default: null }),
    __metadata("design:type", Object)
], ActivityTable.prototype, "comment", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Boolean)
], ActivityTable.prototype, "isLiked", void 0);
__decorate([
    (0, decorators_1.UpdateIdColumn)({ indexName: 'IDX_activity_update_id' }),
    __metadata("design:type", String)
], ActivityTable.prototype, "updateId", void 0);
exports.ActivityTable = ActivityTable = __decorate([
    (0, sql_tools_1.Table)('activity'),
    (0, decorators_1.UpdatedAtTrigger)('activity_updated_at'),
    (0, sql_tools_1.Index)({
        name: 'IDX_activity_like',
        columns: ['assetId', 'userId', 'albumId'],
        unique: true,
        where: '("isLiked" = true)',
    }),
    (0, sql_tools_1.Check)({
        name: 'CHK_2ab1e70f113f450eb40c1e3ec8',
        expression: `("comment" IS NULL AND "isLiked" = true) OR ("comment" IS NOT NULL AND "isLiked" = false)`,
    })
], ActivityTable);
//# sourceMappingURL=activity.table.js.map