"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViewRepository = void 0;
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const database_1 = require("../utils/database");
let ViewRepository = class ViewRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async getUniqueOriginalPaths(userId) {
        const results = await this.db
            .selectFrom('assets')
            .select((eb) => eb.fn('substring', ['assets.originalPath', eb.val('^(.*/)[^/]*$')]).as('directoryPath'))
            .distinct()
            .where('ownerId', '=', (0, database_1.asUuid)(userId))
            .where('isVisible', '=', true)
            .where('isArchived', '=', false)
            .where('deletedAt', 'is', null)
            .where('fileCreatedAt', 'is not', null)
            .where('fileModifiedAt', 'is not', null)
            .where('localDateTime', 'is not', null)
            .execute();
        return results.map((row) => row.directoryPath.replaceAll(/^\/|\/$/g, ''));
    }
    async getAssetsByOriginalPath(userId, partialPath) {
        const normalizedPath = partialPath.replaceAll(/^\/|\/$/g, '');
        return this.db
            .selectFrom('assets')
            .selectAll('assets')
            .$call(database_1.withExif)
            .where('ownerId', '=', (0, database_1.asUuid)(userId))
            .where('isVisible', '=', true)
            .where('isArchived', '=', false)
            .where('deletedAt', 'is', null)
            .where('fileCreatedAt', 'is not', null)
            .where('fileModifiedAt', 'is not', null)
            .where('localDateTime', 'is not', null)
            .where('originalPath', 'like', `%${normalizedPath}/%`)
            .where('originalPath', 'not like', `%${normalizedPath}/%/%`)
            .orderBy((eb) => eb.fn('regexp_replace', ['assets.originalPath', eb.val('.*/(.+)'), eb.val(String.raw `\1`)]), 'asc')
            .execute();
    }
};
exports.ViewRepository = ViewRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ViewRepository.prototype, "getUniqueOriginalPaths", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], ViewRepository.prototype, "getAssetsByOriginalPath", null);
exports.ViewRepository = ViewRepository = __decorate([
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], ViewRepository);
//# sourceMappingURL=view-repository.js.map