import { Kysely } from 'kysely';
import { DB } from 'src/db';
export declare class ViewRepository {
    private db;
    constructor(db: Kysely<DB>);
    getUniqueOriginalPaths(userId: string): Promise<string[]>;
    getAssetsByOriginalPath(userId: string, partialPath: string): Promise<{
        id: string;
        type: import("../enum").AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: import("../enum").AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo: import("../database").Exif | null;
    }[]>;
}
