import { Insertable, Kysely } from 'kysely';
import { DB, VersionHistory } from 'src/db';
export declare class VersionHistoryRepository {
    private db;
    constructor(db: Kysely<DB>);
    getAll(): Promise<{
        version: string;
        id: string;
        createdAt: Date;
    }[]>;
    getLatest(): Promise<{
        version: string;
        id: string;
        createdAt: Date;
    } | undefined>;
    create(version: Insertable<VersionHistory>): Promise<{
        version: string;
        id: string;
        createdAt: Date;
    }>;
}
