import { Insertable, Kysely, Updateable } from 'kysely';
import { DateTime } from 'luxon';
import { DB } from 'src/db';
import { UserStatus } from 'src/enum';
import { UserTable } from 'src/schema/tables/user.table';
import { UserMetadata, UserMetadataItem } from 'src/types';
export interface UserListFilter {
    withDeleted?: boolean;
}
export interface UserStatsQueryResponse {
    userId: string;
    userName: string;
    photos: number;
    videos: number;
    usage: number;
    usagePhotos: number;
    usageVideos: number;
    quotaSizeInBytes: number | null;
}
export interface UserFindOptions {
    withDeleted?: boolean;
}
export declare class UserRepository {
    private db;
    constructor(db: Kysely<DB>);
    get(userId: string, options: UserFindOptions): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
    } | undefined>;
    getMetadata(userId: string): Promise<UserMetadataItem[]>;
    getAdmin(): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
    } | undefined>;
    hasAdmin(): Promise<boolean>;
    getByEmail(email: string, withPassword?: boolean): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
        password?: string | undefined;
    } | undefined>;
    getByStorageLabel(storageLabel: string): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
    } | undefined>;
    getByOAuthId(oauthId: string): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
    } | undefined>;
    getDeletedAfter(target: DateTime): Promise<{
        id: string;
    }[]>;
    getList({ withDeleted }?: UserListFilter): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
    }[]>;
    create(dto: Insertable<UserTable>): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
    }>;
    update(id: string, dto: Updateable<UserTable>): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
    }>;
    restore(id: string): Promise<{
        name: string;
        id: string;
        email: string;
        updatedAt: Date;
        deletedAt: Date | null;
        createdAt: Date;
        status: UserStatus;
        quotaSizeInBytes: number | null;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        oauthId: string;
        storageLabel: string | null;
        quotaUsageInBytes: number;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                avatar?: {
                    color?: import("src/enum").UserAvatarColor | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            };
        }[];
    }>;
    upsertMetadata<T extends keyof UserMetadata>(id: string, { key, value }: {
        key: T;
        value: UserMetadata[T];
    }): Promise<void>;
    deleteMetadata<T extends keyof UserMetadata>(id: string, key: T): Promise<void>;
    delete(user: {
        id: string;
    }, hard?: boolean): Promise<import("kysely").UpdateResult[]> | Promise<import("kysely").DeleteResult[]>;
    getUserStats(): Promise<{
        userId: string;
        userName: string;
        quotaSizeInBytes: number | null;
        usage: number;
        photos: number;
        videos: number;
        usagePhotos: number;
        usageVideos: number;
    }[]>;
    updateUsage(id: string, delta: number): Promise<void>;
    syncUsage(id?: string): Promise<void>;
}
