"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrashRepository = void 0;
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
let TrashRepository = class TrashRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getDeletedIds() {
        return this.db.selectFrom('assets').select(['id']).where('status', '=', enum_1.AssetStatus.DELETED).stream();
    }
    async restore(userId) {
        const { numUpdatedRows } = await this.db
            .updateTable('assets')
            .where('ownerId', '=', userId)
            .where('status', '=', enum_1.AssetStatus.TRASHED)
            .set({ status: enum_1.AssetStatus.ACTIVE, deletedAt: null })
            .executeTakeFirst();
        return Number(numUpdatedRows);
    }
    async empty(userId) {
        const { numUpdatedRows } = await this.db
            .updateTable('assets')
            .where('ownerId', '=', userId)
            .where('status', '=', enum_1.AssetStatus.TRASHED)
            .set({ status: enum_1.AssetStatus.DELETED })
            .executeTakeFirst();
        return Number(numUpdatedRows);
    }
    async restoreAll(ids) {
        if (ids.length === 0) {
            return 0;
        }
        const { numUpdatedRows } = await this.db
            .updateTable('assets')
            .where('status', '=', enum_1.AssetStatus.TRASHED)
            .where('id', 'in', ids)
            .set({ status: enum_1.AssetStatus.ACTIVE, deletedAt: null })
            .executeTakeFirst();
        return Number(numUpdatedRows);
    }
};
exports.TrashRepository = TrashRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TrashRepository.prototype, "restore", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TrashRepository.prototype, "empty", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], TrashRepository.prototype, "restoreAll", null);
exports.TrashRepository = TrashRepository = __decorate([
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], TrashRepository);
//# sourceMappingURL=trash.repository.js.map