import { Insertable, Kysely, Updateable } from 'kysely';
import { DB, TagAsset, Tags } from 'src/db';
import { LoggingRepository } from 'src/repositories/logging.repository';
export declare class TagRepository {
    private db;
    private logger;
    constructor(db: Kysely<DB>, logger: LoggingRepository);
    get(id: string): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    } | undefined>;
    getByValue(userId: string, value: string): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    } | undefined>;
    upsertValue({ userId, value, parentId: _parentId }: {
        userId: string;
        value: string;
        parentId?: string;
    }): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    }>;
    getAll(userId: string): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    }[]>;
    create(tag: Insertable<Tags>): Promise<{
        id: string;
        value: string;
        updateId: string;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
        createdAt: Date;
        userId: string;
    }>;
    update(id: string, dto: Updateable<Tags>): Promise<{
        id: string;
        value: string;
        updateId: string;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
        createdAt: Date;
        userId: string;
    }>;
    delete(id: string): Promise<void>;
    getAssetIds(tagId: string, assetIds: string[]): Promise<Set<string>>;
    addAssetIds(tagId: string, assetIds: string[]): Promise<void>;
    removeAssetIds(tagId: string, assetIds: string[]): Promise<void>;
    upsertAssetIds(items: Insertable<TagAsset>[]): Promise<{
        assetsId: string;
        tagsId: string;
    }[]>;
    replaceAssetTags(assetId: string, tagIds: string[]): Promise<{
        assetsId: string;
        tagsId: string;
    }[] | undefined>;
    deleteEmptyTags(): Promise<void>;
}
