"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemMetadataRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const promises_1 = require("node:fs/promises");
const decorators_1 = require("../decorators");
let SystemMetadataRepository = class SystemMetadataRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async get(key) {
        const metadata = await this.db
            .selectFrom('system_metadata')
            .select('value')
            .where('key', '=', key)
            .executeTakeFirst();
        if (!metadata) {
            return null;
        }
        return metadata.value;
    }
    async set(key, value) {
        await this.db
            .insertInto('system_metadata')
            .values({ key, value })
            .onConflict((oc) => oc.columns(['key']).doUpdateSet({ value }))
            .execute();
    }
    async delete(key) {
        await this.db.deleteFrom('system_metadata').where('key', '=', key).execute();
    }
    readFile(filename) {
        return (0, promises_1.readFile)(filename, { encoding: 'utf8' });
    }
};
exports.SystemMetadataRepository = SystemMetadataRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: ['metadata_key'] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_a = typeof T !== "undefined" && T) === "function" ? _a : Object]),
    __metadata("design:returntype", Promise)
], SystemMetadataRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: ['metadata_key', { foo: 'bar' }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_b = typeof T !== "undefined" && T) === "function" ? _b : Object, Object]),
    __metadata("design:returntype", Promise)
], SystemMetadataRepository.prototype, "set", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: ['metadata_key'] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_c = typeof T !== "undefined" && T) === "function" ? _c : Object]),
    __metadata("design:returntype", Promise)
], SystemMetadataRepository.prototype, "delete", null);
exports.SystemMetadataRepository = SystemMetadataRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SystemMetadataRepository);
//# sourceMappingURL=system-metadata.repository.js.map