import { Kysely } from 'kysely';
import { DB } from 'src/db';
import { SystemMetadata } from 'src/types';
export declare class SystemMetadataRepository {
    private db;
    constructor(db: Kysely<DB>);
    get<T extends keyof SystemMetadata>(key: T): Promise<SystemMetadata[T] | null>;
    set<T extends keyof SystemMetadata>(key: T, value: SystemMetadata[T]): Promise<void>;
    delete<T extends keyof SystemMetadata>(key: T): Promise<void>;
    readFile(filename: string): Promise<string>;
}
