"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
let SyncRepository = class SyncRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getCheckpoints(sessionId) {
        return this.db
            .selectFrom('session_sync_checkpoints')
            .select(['type', 'ack'])
            .where('sessionId', '=', sessionId)
            .execute();
    }
    upsertCheckpoints(items) {
        return this.db
            .insertInto('session_sync_checkpoints')
            .values(items)
            .onConflict((oc) => oc.columns(['sessionId', 'type']).doUpdateSet((eb) => ({
            ack: eb.ref('excluded.ack'),
        })))
            .execute();
    }
    deleteCheckpoints(sessionId, types) {
        return this.db
            .deleteFrom('session_sync_checkpoints')
            .where('sessionId', '=', sessionId)
            .$if(!!types, (qb) => qb.where('type', 'in', types))
            .execute();
    }
    getUserUpserts(ack) {
        return this.db
            .selectFrom('users')
            .select(['id', 'name', 'email', 'deletedAt', 'updateId'])
            .$call((qb) => this.upsertTableFilters(qb, ack))
            .stream();
    }
    getUserDeletes(ack) {
        return this.db
            .selectFrom('users_audit')
            .select(['id', 'userId'])
            .$call((qb) => this.auditTableFilters(qb, ack))
            .stream();
    }
    getPartnerUpserts(userId, ack) {
        return this.db
            .selectFrom('partners')
            .select(['sharedById', 'sharedWithId', 'inTimeline', 'updateId'])
            .where((eb) => eb.or([eb('sharedById', '=', userId), eb('sharedWithId', '=', userId)]))
            .$call((qb) => this.upsertTableFilters(qb, ack))
            .stream();
    }
    getPartnerDeletes(userId, ack) {
        return this.db
            .selectFrom('partners_audit')
            .select(['id', 'sharedById', 'sharedWithId'])
            .where((eb) => eb.or([eb('sharedById', '=', userId), eb('sharedWithId', '=', userId)]))
            .$call((qb) => this.auditTableFilters(qb, ack))
            .stream();
    }
    getAssetUpserts(userId, ack) {
        return this.db
            .selectFrom('assets')
            .select(database_1.columns.syncAsset)
            .where('ownerId', '=', userId)
            .$call((qb) => this.upsertTableFilters(qb, ack))
            .stream();
    }
    getPartnerAssetsUpserts(userId, ack) {
        return this.db
            .selectFrom('assets')
            .select(database_1.columns.syncAsset)
            .where('ownerId', 'in', (eb) => eb.selectFrom('partners').select(['sharedById']).where('sharedWithId', '=', userId))
            .$call((qb) => this.upsertTableFilters(qb, ack))
            .stream();
    }
    getAssetDeletes(userId, ack) {
        return this.db
            .selectFrom('assets_audit')
            .select(['id', 'assetId'])
            .where('ownerId', '=', userId)
            .$if(!!ack, (qb) => qb.where('id', '>', ack.updateId))
            .$call((qb) => this.auditTableFilters(qb, ack))
            .stream();
    }
    getPartnerAssetDeletes(userId, ack) {
        return this.db
            .selectFrom('assets_audit')
            .select(['id', 'assetId'])
            .where('ownerId', 'in', (eb) => eb.selectFrom('partners').select(['sharedById']).where('sharedWithId', '=', userId))
            .$call((qb) => this.auditTableFilters(qb, ack))
            .stream();
    }
    getAssetExifsUpserts(userId, ack) {
        return this.db
            .selectFrom('exif')
            .select(database_1.columns.syncAssetExif)
            .where('assetId', 'in', (eb) => eb.selectFrom('assets').select('id').where('ownerId', '=', userId))
            .$call((qb) => this.upsertTableFilters(qb, ack))
            .stream();
    }
    getPartnerAssetExifsUpserts(userId, ack) {
        return this.db
            .selectFrom('exif')
            .select(database_1.columns.syncAssetExif)
            .where('assetId', 'in', (eb) => eb
            .selectFrom('assets')
            .select('id')
            .where('ownerId', 'in', (eb) => eb.selectFrom('partners').select(['sharedById']).where('sharedWithId', '=', userId)))
            .$call((qb) => this.upsertTableFilters(qb, ack))
            .stream();
    }
    auditTableFilters(qb, ack) {
        const builder = qb;
        return builder
            .where('deletedAt', '<', kysely_1.sql.raw("now() - interval '1 millisecond'"))
            .$if(!!ack, (qb) => qb.where('id', '>', ack.updateId))
            .orderBy(['id asc']);
    }
    upsertTableFilters(qb, ack) {
        const builder = qb;
        return builder
            .where('updatedAt', '<', kysely_1.sql.raw("now() - interval '1 millisecond'"))
            .$if(!!ack, (qb) => qb.where('updateId', '>', ack.updateId))
            .orderBy(['updateId asc']);
    }
};
exports.SyncRepository = SyncRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getCheckpoints", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "deleteCheckpoints", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getUserUpserts", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getUserDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getPartnerUpserts", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getPartnerDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getAssetUpserts", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getPartnerAssetsUpserts", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getAssetDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getPartnerAssetDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getAssetExifsUpserts", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], SyncRepository.prototype, "getPartnerAssetExifsUpserts", null);
exports.SyncRepository = SyncRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SyncRepository);
//# sourceMappingURL=sync.repository.js.map