import { Insertable, Kysely } from 'kysely';
import { DB, SessionSyncCheckpoints } from 'src/db';
import { SyncEntityType } from 'src/enum';
import { SyncAck } from 'src/types';
export declare class SyncRepository {
    private db;
    constructor(db: Kysely<DB>);
    getCheckpoints(sessionId: string): Promise<{
        type: SyncEntityType;
        ack: string;
    }[]>;
    upsertCheckpoints(items: Insertable<SessionSyncCheckpoints>[]): Promise<import("kysely").InsertResult[]>;
    deleteCheckpoints(sessionId: string, types?: SyncEntityType[]): Promise<import("kysely").DeleteResult[]>;
    getUserUpserts(ack?: SyncAck): AsyncIterableIterator<{
        name: string;
        id: string;
        email: string;
        updateId: string;
        deletedAt: Date | null;
    }>;
    getUserDeletes(ack?: SyncAck): AsyncIterableIterator<{
        id: string;
        userId: string;
    }>;
    getPartnerUpserts(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        updateId: string;
        inTimeline: boolean;
        sharedById: string;
        sharedWithId: string;
    }>;
    getPartnerDeletes(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        id: string;
        sharedById: string;
        sharedWithId: string;
    }>;
    getAssetUpserts(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        id: string;
        type: import("src/enum").AssetType;
        updateId: string;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        checksum: Buffer<ArrayBufferLike>;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isVisible: boolean;
        localDateTime: Date;
        thumbhash: Buffer<ArrayBufferLike> | null;
    }>;
    getPartnerAssetsUpserts(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        id: string;
        type: import("src/enum").AssetType;
        updateId: string;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        checksum: Buffer<ArrayBufferLike>;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isVisible: boolean;
        localDateTime: Date;
        thumbhash: Buffer<ArrayBufferLike> | null;
    }>;
    getAssetDeletes(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        id: string;
        assetId: string;
    } & Partial<Omit<unknown, "id" | "assetId">>>;
    getPartnerAssetDeletes(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        id: string;
        assetId: string;
    }>;
    getAssetExifsUpserts(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        assetId: string;
        description: string;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        timeZone: string | null;
        latitude: number | null;
        longitude: number | null;
        projectionType: string | null;
        city: string | null;
        state: string | null;
        country: string | null;
        make: string | null;
        model: string | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        exposureTime: string | null;
        profileDescription: string | null;
        rating: number | null;
        fps: number | null;
        updateId: string;
    }>;
    getPartnerAssetExifsUpserts(userId: string, ack?: SyncAck): AsyncIterableIterator<{
        assetId: string;
        description: string;
        exifImageWidth: number | null;
        exifImageHeight: number | null;
        fileSizeInByte: number | null;
        orientation: string | null;
        dateTimeOriginal: Date | null;
        modifyDate: Date | null;
        timeZone: string | null;
        latitude: number | null;
        longitude: number | null;
        projectionType: string | null;
        city: string | null;
        state: string | null;
        country: string | null;
        make: string | null;
        model: string | null;
        lensModel: string | null;
        fNumber: number | null;
        focalLength: number | null;
        iso: number | null;
        exposureTime: string | null;
        profileDescription: string | null;
        rating: number | null;
        fps: number | null;
        updateId: string;
    }>;
    private auditTableFilters;
    private upsertTableFilters;
}
