import { WatchOptions } from 'chokidar';
import fs from 'node:fs/promises';
import { Readable, Writable } from 'node:stream';
import { CrawlOptionsDto, WalkOptionsDto } from 'src/dtos/library.dto';
import { LoggingRepository } from 'src/repositories/logging.repository';
export interface WatchEvents {
    onReady(): void;
    onAdd(path: string): void;
    onChange(path: string): void;
    onUnlink(path: string): void;
    onError(error: Error): void;
}
export interface ImmichReadStream {
    stream: Readable;
    type?: string;
    length?: number;
}
export interface ImmichZipStream extends ImmichReadStream {
    addFile: (inputPath: string, filename: string) => void;
    finalize: () => Promise<void>;
}
export interface DiskUsage {
    available: number;
    free: number;
    total: number;
}
export declare class StorageRepository {
    private logger;
    constructor(logger: LoggingRepository);
    realpath(filepath: string): Promise<string>;
    readdir(folder: string): Promise<string[]>;
    copyFile(source: string, target: string): Promise<void>;
    stat(filepath: string): Promise<import("fs").Stats>;
    createFile(filepath: string, buffer: Buffer): Promise<void>;
    createWriteStream(filepath: string): Writable;
    createOrOverwriteFile(filepath: string, buffer: Buffer): Promise<void>;
    overwriteFile(filepath: string, buffer: Buffer): Promise<void>;
    rename(source: string, target: string): Promise<void>;
    utimes(filepath: string, atime: Date, mtime: Date): Promise<void>;
    createZipStream(): ImmichZipStream;
    createReadStream(filepath: string, mimeType?: string | null): Promise<ImmichReadStream>;
    readFile(filepath: string, options?: fs.FileReadOptions<Buffer>): Promise<Buffer>;
    checkFileExists(filepath: string, mode?: number): Promise<boolean>;
    unlink(file: string): Promise<void>;
    unlinkDir(folder: string, options: {
        recursive?: boolean;
        force?: boolean;
    }): Promise<void>;
    removeEmptyDirs(directory: string, self?: boolean): Promise<void>;
    mkdirSync(filepath: string): void;
    checkDiskUsage(folder: string): Promise<DiskUsage>;
    crawl(crawlOptions: CrawlOptionsDto): Promise<string[]>;
    walk(walkOptions: WalkOptionsDto): AsyncGenerator<string[]>;
    watch(paths: string[], options: WatchOptions, events: Partial<WatchEvents>): () => Promise<void>;
    private asGlob;
}
