import { Kysely, Updateable } from 'kysely';
import { AssetStack, DB } from 'src/db';
export interface StackSearch {
    ownerId: string;
    primaryAssetId?: string;
}
export declare class StackRepository {
    private db;
    constructor(db: Kysely<DB>);
    search(query: StackSearch): Promise<{
        id: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                state: string | null;
                fileSizeInByte: number | null;
                assetId: string;
                autoStackId: string | null;
                bitsPerSample: number | null;
                city: string | null;
                colorspace: string | null;
                country: string | null;
                dateTimeOriginal: Date | null;
                exifImageHeight: number | null;
                exifImageWidth: number | null;
                exposureTime: string | null;
                fNumber: number | null;
                focalLength: number | null;
                fps: number | null;
                iso: number | null;
                latitude: number | null;
                lensModel: string | null;
                livePhotoCID: string | null;
                longitude: number | null;
                make: string | null;
                model: string | null;
                modifyDate: Date | null;
                orientation: string | null;
                profileDescription: string | null;
                projectionType: string | null;
                rating: number | null;
                timeZone: string | null;
            };
        }[];
    }[]>;
    create(entity: {
        ownerId: string;
        assetIds: string[];
    }): Promise<{
        id: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                state: string | null;
                fileSizeInByte: number | null;
                assetId: string;
                autoStackId: string | null;
                bitsPerSample: number | null;
                city: string | null;
                colorspace: string | null;
                country: string | null;
                dateTimeOriginal: Date | null;
                exifImageHeight: number | null;
                exifImageWidth: number | null;
                exposureTime: string | null;
                fNumber: number | null;
                focalLength: number | null;
                fps: number | null;
                iso: number | null;
                latitude: number | null;
                lensModel: string | null;
                livePhotoCID: string | null;
                longitude: number | null;
                make: string | null;
                model: string | null;
                modifyDate: Date | null;
                orientation: string | null;
                profileDescription: string | null;
                projectionType: string | null;
                rating: number | null;
                timeZone: string | null;
            };
        }[];
    }>;
    delete(id: string): Promise<void>;
    deleteAll(ids: string[]): Promise<void>;
    update(id: string, entity: Updateable<AssetStack>): Promise<{
        id: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                state: string | null;
                fileSizeInByte: number | null;
                assetId: string;
                autoStackId: string | null;
                bitsPerSample: number | null;
                city: string | null;
                colorspace: string | null;
                country: string | null;
                dateTimeOriginal: Date | null;
                exifImageHeight: number | null;
                exifImageWidth: number | null;
                exposureTime: string | null;
                fNumber: number | null;
                focalLength: number | null;
                fps: number | null;
                iso: number | null;
                latitude: number | null;
                lensModel: string | null;
                livePhotoCID: string | null;
                longitude: number | null;
                make: string | null;
                model: string | null;
                modifyDate: Date | null;
                orientation: string | null;
                profileDescription: string | null;
                projectionType: string | null;
                rating: number | null;
                timeZone: string | null;
            };
        }[];
    }>;
    getById(id: string): Promise<{
        id: string;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                state: string | null;
                fileSizeInByte: number | null;
                assetId: string;
                autoStackId: string | null;
                bitsPerSample: number | null;
                city: string | null;
                colorspace: string | null;
                country: string | null;
                dateTimeOriginal: Date | null;
                exifImageHeight: number | null;
                exifImageWidth: number | null;
                exposureTime: string | null;
                fNumber: number | null;
                focalLength: number | null;
                fps: number | null;
                iso: number | null;
                latitude: number | null;
                lensModel: string | null;
                livePhotoCID: string | null;
                longitude: number | null;
                make: string | null;
                model: string | null;
                modifyDate: Date | null;
                orientation: string | null;
                profileDescription: string | null;
                projectionType: string | null;
                rating: number | null;
                timeZone: string | null;
            };
        }[];
    } | undefined>;
}
