"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedLinkRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const lodash_1 = __importDefault(require("lodash"));
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
let SharedLinkRepository = class SharedLinkRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    get(userId, id) {
        return this.db
            .selectFrom('shared_links')
            .selectAll('shared_links')
            .leftJoinLateral((eb) => eb
            .selectFrom('shared_link__asset')
            .whereRef('shared_links.id', '=', 'shared_link__asset.sharedLinksId')
            .innerJoin('assets', 'assets.id', 'shared_link__asset.assetsId')
            .where('assets.deletedAt', 'is', null)
            .selectAll('assets')
            .innerJoinLateral((eb) => eb.selectFrom('exif').selectAll('exif').whereRef('exif.assetId', '=', 'assets.id').as('exifInfo'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson('exifInfo').as('exifInfo'))
            .orderBy('assets.fileCreatedAt', 'asc')
            .as('a'), (join) => join.onTrue())
            .leftJoinLateral((eb) => eb
            .selectFrom('albums')
            .selectAll('albums')
            .whereRef('albums.id', '=', 'shared_links.albumId')
            .where('albums.deletedAt', 'is', null)
            .leftJoin('albums_assets_assets', 'albums_assets_assets.albumsId', 'albums.id')
            .leftJoinLateral((eb) => eb
            .selectFrom('assets')
            .selectAll('assets')
            .whereRef('albums_assets_assets.assetsId', '=', 'assets.id')
            .where('assets.deletedAt', 'is', null)
            .innerJoinLateral((eb) => eb
            .selectFrom('exif')
            .selectAll('exif')
            .whereRef('exif.assetId', '=', 'assets.id')
            .as('assets_exifInfo'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson(eb.table('assets_exifInfo')).as('exifInfo'))
            .orderBy('assets.fileCreatedAt', 'asc')
            .as('assets'), (join) => join.onTrue())
            .innerJoinLateral((eb) => eb
            .selectFrom('users')
            .selectAll('users')
            .whereRef('users.id', '=', 'albums.ownerId')
            .where('users.deletedAt', 'is', null)
            .as('owner'), (join) => join.onTrue())
            .select((eb) => eb.fn.coalesce(eb.fn.jsonAgg('assets').filterWhere('assets.id', 'is not', null), (0, kysely_1.sql) `'[]'`).as('assets'))
            .select((eb) => eb.fn.toJson('owner').as('owner'))
            .groupBy(['albums.id', (0, kysely_1.sql) `"owner".*`])
            .as('album'), (join) => join.onTrue())
            .select((eb) => eb.fn
            .coalesce(eb.fn.jsonAgg('a').filterWhere('a.id', 'is not', null), (0, kysely_1.sql) `'[]'`)
            .$castTo()
            .as('assets'))
            .groupBy(['shared_links.id', (0, kysely_1.sql) `"album".*`])
            .select((eb) => eb.fn.toJson('album').$castTo().as('album'))
            .where('shared_links.id', '=', id)
            .where('shared_links.userId', '=', userId)
            .where((eb) => eb.or([eb('shared_links.type', '=', enum_1.SharedLinkType.INDIVIDUAL), eb('album.id', 'is not', null)]))
            .orderBy('shared_links.createdAt', 'desc')
            .executeTakeFirst();
    }
    getAll({ userId, albumId }) {
        return this.db
            .selectFrom('shared_links')
            .selectAll('shared_links')
            .where('shared_links.userId', '=', userId)
            .leftJoin('shared_link__asset', 'shared_link__asset.sharedLinksId', 'shared_links.id')
            .leftJoinLateral((eb) => eb
            .selectFrom('assets')
            .select((eb) => eb.fn.jsonAgg('assets').as('assets'))
            .whereRef('assets.id', '=', 'shared_link__asset.assetsId')
            .where('assets.deletedAt', 'is', null)
            .as('assets'), (join) => join.onTrue())
            .select('assets.assets')
            .$narrowType()
            .leftJoinLateral((eb) => eb
            .selectFrom('albums')
            .selectAll('albums')
            .whereRef('albums.id', '=', 'shared_links.albumId')
            .innerJoinLateral((eb) => eb
            .selectFrom('users')
            .select([
            'users.id',
            'users.email',
            'users.createdAt',
            'users.profileImagePath',
            'users.isAdmin',
            'users.shouldChangePassword',
            'users.deletedAt',
            'users.oauthId',
            'users.updatedAt',
            'users.storageLabel',
            'users.name',
            'users.quotaSizeInBytes',
            'users.quotaUsageInBytes',
            'users.status',
            'users.profileChangedAt',
        ])
            .whereRef('users.id', '=', 'albums.ownerId')
            .where('users.deletedAt', 'is', null)
            .as('owner'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson('owner').as('owner'))
            .where('albums.deletedAt', 'is', null)
            .as('album'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson('album').$castTo().as('album'))
            .where((eb) => eb.or([eb('shared_links.type', '=', enum_1.SharedLinkType.INDIVIDUAL), eb('album.id', 'is not', null)]))
            .$if(!!albumId, (eb) => eb.where('shared_links.albumId', '=', albumId))
            .orderBy('shared_links.createdAt', 'desc')
            .distinctOn(['shared_links.createdAt'])
            .execute();
    }
    async getByKey(key) {
        return this.db
            .selectFrom('shared_links')
            .where('shared_links.key', '=', key)
            .leftJoin('albums', 'albums.id', 'shared_links.albumId')
            .where('albums.deletedAt', 'is', null)
            .select((eb) => [
            ...database_1.columns.authSharedLink,
            (0, postgres_1.jsonObjectFrom)(eb.selectFrom('users').select(database_1.columns.authUser).whereRef('users.id', '=', 'shared_links.userId')).as('user'),
        ])
            .where((eb) => eb.or([eb('shared_links.type', '=', enum_1.SharedLinkType.INDIVIDUAL), eb('albums.id', 'is not', null)]))
            .executeTakeFirst();
    }
    async create(entity) {
        const { id } = await this.db
            .insertInto('shared_links')
            .values(lodash_1.default.omit(entity, 'assetIds'))
            .returningAll()
            .executeTakeFirstOrThrow();
        if (entity.assetIds && entity.assetIds.length > 0) {
            await this.db
                .insertInto('shared_link__asset')
                .values(entity.assetIds.map((assetsId) => ({ assetsId, sharedLinksId: id })))
                .execute();
        }
        return this.getSharedLinks(id);
    }
    async update(entity) {
        const { id } = await this.db
            .updateTable('shared_links')
            .set(lodash_1.default.omit(entity, 'assets', 'album', 'assetIds'))
            .where('shared_links.id', '=', entity.id)
            .returningAll()
            .executeTakeFirstOrThrow();
        if (entity.assetIds && entity.assetIds.length > 0) {
            await this.db
                .insertInto('shared_link__asset')
                .values(entity.assetIds.map((assetsId) => ({ assetsId, sharedLinksId: id })))
                .execute();
        }
        return this.getSharedLinks(id);
    }
    async remove(id) {
        await this.db.deleteFrom('shared_links').where('shared_links.id', '=', id).execute();
    }
    getSharedLinks(id) {
        return this.db
            .selectFrom('shared_links')
            .selectAll('shared_links')
            .where('shared_links.id', '=', id)
            .leftJoin('shared_link__asset', 'shared_link__asset.sharedLinksId', 'shared_links.id')
            .leftJoinLateral((eb) => eb
            .selectFrom('assets')
            .whereRef('assets.id', '=', 'shared_link__asset.assetsId')
            .selectAll('assets')
            .innerJoinLateral((eb) => eb.selectFrom('exif').whereRef('exif.assetId', '=', 'assets.id').selectAll().as('exif'), (join) => join.onTrue())
            .as('assets'), (join) => join.onTrue())
            .select((eb) => eb.fn
            .coalesce(eb.fn.jsonAgg('assets').filterWhere('assets.id', 'is not', null), (0, kysely_1.sql) `'[]'`)
            .$castTo()
            .as('assets'))
            .groupBy('shared_links.id')
            .executeTakeFirstOrThrow();
    }
};
exports.SharedLinkRepository = SharedLinkRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], SharedLinkRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ userId: decorators_1.DummyValue.UUID, albumId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SharedLinkRepository.prototype, "getAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.BUFFER] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Buffer]),
    __metadata("design:returntype", Promise)
], SharedLinkRepository.prototype, "getByKey", null);
exports.SharedLinkRepository = SharedLinkRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SharedLinkRepository);
//# sourceMappingURL=shared-link.repository.js.map