import { Insertable, Kysely, Updateable } from 'kysely';
import { Album } from 'src/database';
import { DB, SharedLinks } from 'src/db';
import { MapAsset } from 'src/dtos/asset-response.dto';
import { SharedLinkType } from 'src/enum';
export type SharedLinkSearchOptions = {
    userId: string;
    albumId?: string;
};
export declare class SharedLinkRepository {
    private db;
    constructor(db: Kysely<DB>);
    get(userId: string, id: string): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        allowDownload: boolean;
        allowUpload: boolean;
        expiresAt: Date | null;
        showExif: boolean;
        assets: MapAsset[];
        album: Album | null;
    } | undefined>;
    getAll({ userId, albumId }: SharedLinkSearchOptions): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        assets: {
            id: string;
            type: import("src/enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("src/enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[];
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        allowDownload: boolean;
        allowUpload: boolean;
        expiresAt: Date | null;
        showExif: boolean;
        album: Album | null;
    }[]>;
    getByKey(key: Buffer): Promise<{
        id: string;
        userId: string;
        expiresAt: Date | null;
        showExif: boolean;
        allowUpload: boolean;
        allowDownload: boolean;
        password: string | null;
        user: {
            id: string;
            name: string;
            email: string;
            isAdmin: boolean;
            quotaUsageInBytes: number;
            quotaSizeInBytes: number | null;
        } | null;
    } | undefined>;
    create(entity: Insertable<SharedLinks> & {
        assetIds?: string[];
    }): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        allowDownload: boolean;
        allowUpload: boolean;
        expiresAt: Date | null;
        showExif: boolean;
        assets: MapAsset[];
    }>;
    update(entity: Updateable<SharedLinks> & {
        id: string;
        assetIds?: string[];
    }): Promise<{
        password: string | null;
        key: Buffer<ArrayBufferLike>;
        id: string;
        type: SharedLinkType;
        description: string | null;
        createdAt: Date;
        userId: string;
        albumId: string | null;
        allowDownload: boolean;
        allowUpload: boolean;
        expiresAt: Date | null;
        showExif: boolean;
        assets: MapAsset[];
    }>;
    remove(id: string): Promise<void>;
    private getSharedLinks;
}
