"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const database_2 = require("../utils/database");
let SessionRepository = class SessionRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    search(options) {
        return this.db
            .selectFrom('sessions')
            .selectAll()
            .where('sessions.updatedAt', '<=', options.updatedBefore)
            .execute();
    }
    getByToken(token) {
        return this.db
            .selectFrom('sessions')
            .select((eb) => [
            ...database_1.columns.authSession,
            (0, postgres_1.jsonObjectFrom)(eb
                .selectFrom('users')
                .select(database_1.columns.authUser)
                .whereRef('users.id', '=', 'sessions.userId')
                .where('users.deletedAt', 'is', null)).as('user'),
        ])
            .where('sessions.token', '=', token)
            .executeTakeFirst();
    }
    getByUserId(userId) {
        return this.db
            .selectFrom('sessions')
            .innerJoin('users', (join) => join.onRef('users.id', '=', 'sessions.userId').on('users.deletedAt', 'is', null))
            .selectAll('sessions')
            .where('sessions.userId', '=', userId)
            .orderBy('sessions.updatedAt', 'desc')
            .orderBy('sessions.createdAt', 'desc')
            .execute();
    }
    create(dto) {
        return this.db.insertInto('sessions').values(dto).returningAll().executeTakeFirstOrThrow();
    }
    update(id, dto) {
        return this.db
            .updateTable('sessions')
            .set(dto)
            .where('sessions.id', '=', (0, database_2.asUuid)(id))
            .returningAll()
            .executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('sessions').where('id', '=', (0, database_2.asUuid)(id)).execute();
    }
};
exports.SessionRepository = SessionRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ updatedBefore: decorators_1.DummyValue.DATE }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SessionRepository.prototype, "search", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SessionRepository.prototype, "getByToken", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SessionRepository.prototype, "getByUserId", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], SessionRepository.prototype, "delete", null);
exports.SessionRepository = SessionRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SessionRepository);
//# sourceMappingURL=session.repository.js.map