import { Insertable, Kysely, Updateable } from 'kysely';
import { DB, Sessions } from 'src/db';
export type SessionSearchOptions = {
    updatedBefore: Date;
};
export declare class SessionRepository {
    private db;
    constructor(db: Kysely<DB>);
    search(options: SessionSearchOptions): Promise<{
        id: string;
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        deviceOS: string;
        deviceType: string;
        token: string;
    }[]>;
    getByToken(token: string): Promise<{
        id: string;
        updatedAt: Date;
        user: {
            id: string;
            name: string;
            email: string;
            isAdmin: boolean;
            quotaUsageInBytes: number;
            quotaSizeInBytes: number | null;
        } | null;
    } | undefined>;
    getByUserId(userId: string): Promise<{
        id: string;
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        deviceOS: string;
        deviceType: string;
        token: string;
    }[]>;
    create(dto: Insertable<Sessions>): Promise<{
        id: string;
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        deviceOS: string;
        deviceType: string;
        token: string;
    }>;
    update(id: string, dto: Updateable<Sessions>): Promise<{
        id: string;
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        userId: string;
        deviceOS: string;
        deviceType: string;
        token: string;
    }>;
    delete(id: string): Promise<void>;
}
