"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const node_crypto_1 = require("node:crypto");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_1 = require("../utils/database");
const validation_1 = require("../validation");
let SearchRepository = class SearchRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async searchMetadata(pagination, options) {
        const orderDirection = (options.orderDirection?.toLowerCase() || 'desc');
        const items = await (0, database_1.searchAssetBuilder)(this.db, options)
            .orderBy('assets.fileCreatedAt', orderDirection)
            .limit(pagination.size + 1)
            .offset((pagination.page - 1) * pagination.size)
            .execute();
        const hasNextPage = items.length > pagination.size;
        items.splice(pagination.size);
        return { items, hasNextPage };
    }
    async searchRandom(size, options) {
        const uuid = (0, node_crypto_1.randomUUID)();
        const builder = (0, database_1.searchAssetBuilder)(this.db, options);
        const lessThan = builder
            .where('assets.id', '<', uuid)
            .orderBy((0, kysely_1.sql) `random()`)
            .limit(size);
        const greaterThan = builder
            .where('assets.id', '>', uuid)
            .orderBy((0, kysely_1.sql) `random()`)
            .limit(size);
        const { rows } = await (0, kysely_1.sql) `${lessThan} union all ${greaterThan} limit ${size}`.execute(this.db);
        return rows;
    }
    async searchSmart(pagination, options) {
        if (!(0, validation_1.isValidInteger)(pagination.size, { min: 1, max: 1000 })) {
            throw new Error(`Invalid value for 'size': ${pagination.size}`);
        }
        const items = await (0, database_1.searchAssetBuilder)(this.db, options)
            .innerJoin('smart_search', 'assets.id', 'smart_search.assetId')
            .orderBy((0, kysely_1.sql) `smart_search.embedding <=> ${options.embedding}`)
            .limit(pagination.size + 1)
            .offset((pagination.page - 1) * pagination.size)
            .execute();
        const hasNextPage = items.length > pagination.size;
        items.splice(pagination.size);
        return { items, hasNextPage };
    }
    searchDuplicates({ assetId, embedding, maxDistance, type, userIds }) {
        return this.db
            .with('cte', (qb) => qb
            .selectFrom('assets')
            .select([
            'assets.id as assetId',
            'assets.duplicateId',
            (0, kysely_1.sql) `smart_search.embedding <=> ${embedding}`.as('distance'),
        ])
            .innerJoin('smart_search', 'assets.id', 'smart_search.assetId')
            .where('assets.ownerId', '=', (0, database_1.anyUuid)(userIds))
            .where('assets.deletedAt', 'is', null)
            .where('assets.isVisible', '=', true)
            .where('assets.type', '=', type)
            .where('assets.id', '!=', (0, database_1.asUuid)(assetId))
            .where('assets.stackId', 'is', null)
            .orderBy((0, kysely_1.sql) `smart_search.embedding <=> ${embedding}`)
            .limit(64))
            .selectFrom('cte')
            .selectAll()
            .where('cte.distance', '<=', maxDistance)
            .execute();
    }
    searchFaces({ userIds, embedding, numResults, maxDistance, hasPerson, minBirthDate }) {
        if (!(0, validation_1.isValidInteger)(numResults, { min: 1, max: 1000 })) {
            throw new Error(`Invalid value for 'numResults': ${numResults}`);
        }
        return this.db
            .with('cte', (qb) => qb
            .selectFrom('asset_faces')
            .select([
            'asset_faces.id',
            'asset_faces.personId',
            (0, kysely_1.sql) `face_search.embedding <=> ${embedding}`.as('distance'),
        ])
            .innerJoin('assets', 'assets.id', 'asset_faces.assetId')
            .innerJoin('face_search', 'face_search.faceId', 'asset_faces.id')
            .leftJoin('person', 'person.id', 'asset_faces.personId')
            .where('assets.ownerId', '=', (0, database_1.anyUuid)(userIds))
            .where('assets.deletedAt', 'is', null)
            .$if(!!hasPerson, (qb) => qb.where('asset_faces.personId', 'is not', null))
            .$if(!!minBirthDate, (qb) => qb.where((eb) => eb.or([eb('person.birthDate', 'is', null), eb('person.birthDate', '<=', minBirthDate)])))
            .orderBy((0, kysely_1.sql) `face_search.embedding <=> ${embedding}`)
            .limit(numResults))
            .selectFrom('cte')
            .selectAll()
            .where('cte.distance', '<=', maxDistance)
            .execute();
    }
    searchPlaces(placeName) {
        return this.db
            .selectFrom('geodata_places')
            .selectAll()
            .where(() => (0, kysely_1.sql) `
            f_unaccent(name) %>> f_unaccent(${placeName}) or
            f_unaccent("admin2Name") %>> f_unaccent(${placeName}) or
            f_unaccent("admin1Name") %>> f_unaccent(${placeName}) or
            f_unaccent("alternateNames") %>> f_unaccent(${placeName})
          `)
            .orderBy((0, kysely_1.sql) `
          coalesce(f_unaccent(name) <->>> f_unaccent(${placeName}), 0.1) +
          coalesce(f_unaccent("admin2Name") <->>> f_unaccent(${placeName}), 0.1) +
          coalesce(f_unaccent("admin1Name") <->>> f_unaccent(${placeName}), 0.1) +
          coalesce(f_unaccent("alternateNames") <->>> f_unaccent(${placeName}), 0.1)
        `)
            .limit(20)
            .execute();
    }
    getAssetsByCity(userIds) {
        return this.db
            .withRecursive('cte', (qb) => {
            const base = qb
                .selectFrom('exif')
                .select(['city', 'assetId'])
                .innerJoin('assets', 'assets.id', 'exif.assetId')
                .where('assets.ownerId', '=', (0, database_1.anyUuid)(userIds))
                .where('assets.isVisible', '=', true)
                .where('assets.isArchived', '=', false)
                .where('assets.type', '=', enum_1.AssetType.IMAGE)
                .where('assets.deletedAt', 'is', null)
                .orderBy('city')
                .limit(1);
            const recursive = qb
                .selectFrom('cte')
                .select(['l.city', 'l.assetId'])
                .innerJoinLateral((qb) => qb
                .selectFrom('exif')
                .select(['city', 'assetId'])
                .innerJoin('assets', 'assets.id', 'exif.assetId')
                .where('assets.ownerId', '=', (0, database_1.anyUuid)(userIds))
                .where('assets.isVisible', '=', true)
                .where('assets.isArchived', '=', false)
                .where('assets.type', '=', enum_1.AssetType.IMAGE)
                .where('assets.deletedAt', 'is', null)
                .whereRef('exif.city', '>', 'cte.city')
                .orderBy('city')
                .limit(1)
                .as('l'), (join) => join.onTrue());
            return (0, kysely_1.sql) `(${base} union all ${recursive})`;
        })
            .selectFrom('assets')
            .innerJoin('exif', 'assets.id', 'exif.assetId')
            .innerJoin('cte', 'assets.id', 'cte.assetId')
            .selectAll('assets')
            .select((eb) => eb
            .fn('to_jsonb', [eb.table('exif')])
            .$castTo()
            .as('exifInfo'))
            .orderBy('exif.city')
            .execute();
    }
    async upsert(assetId, embedding) {
        await this.db
            .insertInto('smart_search')
            .values({ assetId: (0, database_1.asUuid)(assetId), embedding })
            .onConflict((oc) => oc.column('assetId').doUpdateSet({ embedding }))
            .execute();
    }
    async getDimensionSize() {
        const { rows } = await (0, kysely_1.sql) `
      select atttypmod as dimsize
      from pg_attribute f
        join pg_class c ON c.oid = f.attrelid
      where c.relkind = 'r'::char
        and f.attnum > 0
        and c.relname = 'smart_search'
        and f.attname = 'embedding'
    `.execute(this.db);
        const dimSize = rows[0]['dimsize'];
        if (!(0, validation_1.isValidInteger)(dimSize, { min: 1, max: 2 ** 16 })) {
            throw new Error(`Could not retrieve CLIP dimension size`);
        }
        return dimSize;
    }
    setDimensionSize(dimSize) {
        if (!(0, validation_1.isValidInteger)(dimSize, { min: 1, max: 2 ** 16 })) {
            throw new Error(`Invalid CLIP dimension size: ${dimSize}`);
        }
        return this.db.transaction().execute(async (trx) => {
            await (0, kysely_1.sql) `truncate ${kysely_1.sql.table('smart_search')}`.execute(trx);
            await trx.schema
                .alterTable('smart_search')
                .alterColumn('embedding', (col) => col.setDataType(kysely_1.sql.raw(`vector(${dimSize})`)))
                .execute();
            await (0, kysely_1.sql) `reindex index clip_index`.execute(trx);
        });
    }
    async deleteAllSearchEmbeddings() {
        await (0, kysely_1.sql) `truncate ${kysely_1.sql.table('smart_search')}`.execute(this.db);
    }
    async getCountries(userIds) {
        const res = await this.getExifField('country', userIds).execute();
        return res.map((row) => row.country);
    }
    async getStates(userIds, { country }) {
        const res = await this.getExifField('state', userIds)
            .$if(!!country, (qb) => qb.where('country', '=', country))
            .execute();
        return res.map((row) => row.state);
    }
    async getCities(userIds, { country, state }) {
        const res = await this.getExifField('city', userIds)
            .$if(!!country, (qb) => qb.where('country', '=', country))
            .$if(!!state, (qb) => qb.where('state', '=', state))
            .execute();
        return res.map((row) => row.city);
    }
    async getCameraMakes(userIds, { model }) {
        const res = await this.getExifField('make', userIds)
            .$if(!!model, (qb) => qb.where('model', '=', model))
            .execute();
        return res.map((row) => row.make);
    }
    async getCameraModels(userIds, { make }) {
        const res = await this.getExifField('model', userIds)
            .$if(!!make, (qb) => qb.where('make', '=', make))
            .execute();
        return res.map((row) => row.model);
    }
    getExifField(field, userIds) {
        return this.db
            .selectFrom('exif')
            .select(field)
            .distinctOn(field)
            .innerJoin('assets', 'assets.id', 'exif.assetId')
            .where('ownerId', '=', (0, database_1.anyUuid)(userIds))
            .where('isVisible', '=', true)
            .where('deletedAt', 'is', null)
            .where(field, 'is not', null);
    }
};
exports.SearchRepository = SearchRepository;
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            { page: 1, size: 100 },
            {
                takenAfter: decorators_1.DummyValue.DATE,
                lensModel: decorators_1.DummyValue.STRING,
                withStacked: true,
                isFavorite: true,
                userIds: [decorators_1.DummyValue.UUID],
            },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], SearchRepository.prototype, "searchMetadata", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            100,
            {
                takenAfter: decorators_1.DummyValue.DATE,
                lensModel: decorators_1.DummyValue.STRING,
                withStacked: true,
                isFavorite: true,
                userIds: [decorators_1.DummyValue.UUID],
            },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], SearchRepository.prototype, "searchRandom", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            { page: 1, size: 200 },
            {
                takenAfter: decorators_1.DummyValue.DATE,
                embedding: decorators_1.DummyValue.VECTOR,
                lensModel: decorators_1.DummyValue.STRING,
                withStacked: true,
                isFavorite: true,
                userIds: [decorators_1.DummyValue.UUID],
            },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], SearchRepository.prototype, "searchSmart", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            {
                assetId: decorators_1.DummyValue.UUID,
                embedding: decorators_1.DummyValue.VECTOR,
                maxDistance: 0.6,
                type: enum_1.AssetType.IMAGE,
                userIds: [decorators_1.DummyValue.UUID],
            },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SearchRepository.prototype, "searchDuplicates", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            {
                userIds: [decorators_1.DummyValue.UUID],
                embedding: decorators_1.DummyValue.VECTOR,
                numResults: 10,
                maxDistance: 0.6,
            },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SearchRepository.prototype, "searchFaces", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SearchRepository.prototype, "searchPlaces", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], SearchRepository.prototype, "getAssetsByCity", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID], decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", Promise)
], SearchRepository.prototype, "getStates", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID], decorators_1.DummyValue.STRING, decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", Promise)
], SearchRepository.prototype, "getCities", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID], decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", Promise)
], SearchRepository.prototype, "getCameraMakes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID], decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", Promise)
], SearchRepository.prototype, "getCameraModels", null);
exports.SearchRepository = SearchRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SearchRepository);
//# sourceMappingURL=search.repository.js.map