import { Kysely } from 'kysely';
import { DB } from 'src/db';
import { MapAsset } from 'src/dtos/asset-response.dto';
import { AssetStatus, AssetType } from 'src/enum';
export interface SearchResult<T> {
    total: number;
    count: number;
    page: number;
    items: T[];
    distances: number[];
    facets: SearchFacet[];
}
export interface SearchFacet {
    fieldName: string;
    counts: Array<{
        count: number;
        value: string;
    }>;
}
export type SearchExploreItemSet<T> = Array<{
    value: string;
    data: T;
}>;
export interface SearchExploreItem<T> {
    fieldName: string;
    items: SearchExploreItemSet<T>;
}
export interface SearchAssetIDOptions {
    checksum?: Buffer;
    deviceAssetId?: string;
    id?: string;
}
export interface SearchUserIdOptions {
    deviceId?: string;
    libraryId?: string | null;
    userIds?: string[];
}
export type SearchIdOptions = SearchAssetIDOptions & SearchUserIdOptions;
export interface SearchStatusOptions {
    isArchived?: boolean;
    isEncoded?: boolean;
    isFavorite?: boolean;
    isMotion?: boolean;
    isOffline?: boolean;
    isVisible?: boolean;
    isNotInAlbum?: boolean;
    type?: AssetType;
    status?: AssetStatus;
    withArchived?: boolean;
    withDeleted?: boolean;
}
export interface SearchOneToOneRelationOptions {
    withExif?: boolean;
    withStacked?: boolean;
}
export interface SearchRelationOptions extends SearchOneToOneRelationOptions {
    withFaces?: boolean;
    withPeople?: boolean;
}
export interface SearchDateOptions {
    createdBefore?: Date;
    createdAfter?: Date;
    takenBefore?: Date;
    takenAfter?: Date;
    trashedBefore?: Date;
    trashedAfter?: Date;
    updatedBefore?: Date;
    updatedAfter?: Date;
}
export interface SearchPathOptions {
    encodedVideoPath?: string;
    originalFileName?: string;
    originalPath?: string;
    previewPath?: string;
    thumbnailPath?: string;
}
export interface SearchExifOptions {
    city?: string | null;
    country?: string | null;
    lensModel?: string | null;
    make?: string | null;
    model?: string | null;
    state?: string | null;
    description?: string | null;
    rating?: number | null;
}
export interface SearchEmbeddingOptions {
    embedding: string;
    userIds: string[];
}
export interface SearchPeopleOptions {
    personIds?: string[];
}
export interface SearchTagOptions {
    tagIds?: string[];
}
export interface SearchOrderOptions {
    orderDirection?: 'asc' | 'desc';
}
export interface SearchPaginationOptions {
    page: number;
    size: number;
}
type BaseAssetSearchOptions = SearchDateOptions & SearchIdOptions & SearchExifOptions & SearchOrderOptions & SearchPathOptions & SearchStatusOptions & SearchUserIdOptions & SearchPeopleOptions & SearchTagOptions;
export type AssetSearchOptions = BaseAssetSearchOptions & SearchRelationOptions;
export type AssetSearchOneToOneRelationOptions = BaseAssetSearchOptions & SearchOneToOneRelationOptions;
export type AssetSearchBuilderOptions = Omit<AssetSearchOptions, 'orderDirection'>;
export type SmartSearchOptions = SearchDateOptions & SearchEmbeddingOptions & SearchExifOptions & SearchOneToOneRelationOptions & SearchStatusOptions & SearchUserIdOptions & SearchPeopleOptions & SearchTagOptions;
export interface FaceEmbeddingSearch extends SearchEmbeddingOptions {
    hasPerson?: boolean;
    numResults: number;
    maxDistance: number;
    minBirthDate?: Date | null;
}
export interface AssetDuplicateSearch {
    assetId: string;
    embedding: string;
    maxDistance: number;
    type: AssetType;
    userIds: string[];
}
export interface FaceSearchResult {
    distance: number;
    id: string;
    personId: string | null;
}
export interface AssetDuplicateResult {
    assetId: string;
    duplicateId: string | null;
    distance: number;
}
export interface GetStatesOptions {
    country?: string;
}
export interface GetCitiesOptions extends GetStatesOptions {
    state?: string;
}
export interface GetCameraModelsOptions {
    make?: string;
}
export interface GetCameraMakesOptions {
    model?: string;
}
export declare class SearchRepository {
    private db;
    constructor(db: Kysely<DB>);
    searchMetadata(pagination: SearchPaginationOptions, options: AssetSearchOptions): Promise<{
        items: {
            id: string;
            type: AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
            exifInfo?: import("../database").Exif | undefined;
            faces?: {
                id: string;
                assetId: string;
                imageHeight: number;
                imageWidth: number;
                boundingBoxX1: number;
                boundingBoxX2: number;
                boundingBoxY1: number;
                boundingBoxY2: number;
                sourceType: import("src/enum").SourceType;
                personId: string | null;
                deletedAt: Date | null;
                person: import("../database").Person;
            }[] | undefined;
        }[];
        hasNextPage: boolean;
    }>;
    searchRandom(size: number, options: AssetSearchOptions): Promise<MapAsset[]>;
    searchSmart(pagination: SearchPaginationOptions, options: SmartSearchOptions): Promise<{
        items: {
            id: string;
            type: AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
            exifInfo?: import("../database").Exif | undefined;
            faces?: {
                id: string;
                assetId: string;
                imageHeight: number;
                imageWidth: number;
                boundingBoxX1: number;
                boundingBoxX2: number;
                boundingBoxY1: number;
                boundingBoxY2: number;
                sourceType: import("src/enum").SourceType;
                personId: string | null;
                deletedAt: Date | null;
                person: import("../database").Person;
            }[] | undefined;
        }[];
        hasNextPage: boolean;
    }>;
    searchDuplicates({ assetId, embedding, maxDistance, type, userIds }: AssetDuplicateSearch): Promise<{
        assetId: string;
        duplicateId: string | null;
        distance: number;
    }[]>;
    searchFaces({ userIds, embedding, numResults, maxDistance, hasPerson, minBirthDate }: FaceEmbeddingSearch): Promise<{
        id: string;
        personId: string | null;
        distance: number;
    }[]>;
    searchPlaces(placeName: string): Promise<{
        name: string;
        id: number;
        latitude: number;
        longitude: number;
        admin1Code: string | null;
        admin1Name: string | null;
        admin2Code: string | null;
        admin2Name: string | null;
        alternateNames: string | null;
        countryCode: string;
        modificationDate: Date;
    }[]>;
    getAssetsByCity(userIds: string[]): Promise<{
        id: string;
        type: AssetType;
        updateId: string;
        updatedAt: Date;
        isFavorite: boolean;
        deletedAt: Date | null;
        ownerId: string;
        libraryId: string | null;
        createdAt: Date;
        status: AssetStatus;
        checksum: Buffer<ArrayBufferLike>;
        deviceAssetId: string;
        deviceId: string;
        duplicateId: string | null;
        duration: string | null;
        encodedVideoPath: string | null;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isArchived: boolean;
        isExternal: boolean;
        isOffline: boolean;
        isVisible: boolean;
        livePhotoVideoId: string | null;
        localDateTime: Date;
        originalFileName: string;
        originalPath: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        stackId: string | null;
        exifInfo: {
            description: string;
            state: string | null;
            fileSizeInByte: number | null;
            assetId: string;
            updateId: string;
            updatedAt: Date;
            autoStackId: string | null;
            bitsPerSample: number | null;
            city: string | null;
            colorspace: string | null;
            country: string | null;
            dateTimeOriginal: Date | null;
            exifImageHeight: number | null;
            exifImageWidth: number | null;
            exposureTime: string | null;
            fNumber: number | null;
            focalLength: number | null;
            fps: number | null;
            iso: number | null;
            latitude: number | null;
            lensModel: string | null;
            livePhotoCID: string | null;
            longitude: number | null;
            make: string | null;
            model: string | null;
            modifyDate: Date | null;
            orientation: string | null;
            profileDescription: string | null;
            projectionType: string | null;
            rating: number | null;
            timeZone: string | null;
        };
    }[]>;
    upsert(assetId: string, embedding: string): Promise<void>;
    getDimensionSize(): Promise<number>;
    setDimensionSize(dimSize: number): Promise<void>;
    deleteAllSearchEmbeddings(): Promise<void>;
    getCountries(userIds: string[]): Promise<string[]>;
    getStates(userIds: string[], { country }: GetStatesOptions): Promise<string[]>;
    getCities(userIds: string[], { country, state }: GetCitiesOptions): Promise<string[]>;
    getCameraMakes(userIds: string[], { model }: GetCameraMakesOptions): Promise<string[]>;
    getCameraModels(userIds: string[], { make }: GetCameraModelsOptions): Promise<string[]>;
    private getExifField;
}
export {};
