"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersonRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_1 = require("../utils/database");
const withPerson = (eb) => {
    return (0, postgres_1.jsonObjectFrom)(eb.selectFrom('person').selectAll('person').whereRef('person.id', '=', 'asset_faces.personId')).as('person');
};
const withAsset = (eb) => {
    return (0, postgres_1.jsonObjectFrom)(eb.selectFrom('assets').selectAll('assets').whereRef('assets.id', '=', 'asset_faces.assetId')).as('asset');
};
const withFaceSearch = (eb) => {
    return (0, postgres_1.jsonObjectFrom)(eb.selectFrom('face_search').selectAll('face_search').whereRef('face_search.faceId', '=', 'asset_faces.id')).as('faceSearch');
};
let PersonRepository = class PersonRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async reassignFaces({ oldPersonId, faceIds, newPersonId }) {
        const result = await this.db
            .updateTable('asset_faces')
            .set({ personId: newPersonId })
            .$if(!!oldPersonId, (qb) => qb.where('asset_faces.personId', '=', oldPersonId))
            .$if(!!faceIds, (qb) => qb.where('asset_faces.id', 'in', faceIds))
            .executeTakeFirst();
        return Number(result.numChangedRows ?? 0);
    }
    async unassignFaces({ sourceType }) {
        await this.db
            .updateTable('asset_faces')
            .set({ personId: null })
            .where('asset_faces.sourceType', '=', sourceType)
            .execute();
        await this.vacuum({ reindexVectors: false });
    }
    async delete(ids) {
        if (ids.length === 0) {
            return;
        }
        await this.db.deleteFrom('person').where('person.id', 'in', ids).execute();
    }
    async deleteFaces({ sourceType }) {
        await this.db.deleteFrom('asset_faces').where('asset_faces.sourceType', '=', sourceType).execute();
        await this.vacuum({ reindexVectors: sourceType === enum_1.SourceType.MACHINE_LEARNING });
    }
    getAllFaces(options = {}) {
        return this.db
            .selectFrom('asset_faces')
            .selectAll('asset_faces')
            .$if(options.personId === null, (qb) => qb.where('asset_faces.personId', 'is', null))
            .$if(!!options.personId, (qb) => qb.where('asset_faces.personId', '=', options.personId))
            .$if(!!options.sourceType, (qb) => qb.where('asset_faces.sourceType', '=', options.sourceType))
            .$if(!!options.assetId, (qb) => qb.where('asset_faces.assetId', '=', options.assetId))
            .where('asset_faces.deletedAt', 'is', null)
            .stream();
    }
    getAll(options = {}) {
        return this.db
            .selectFrom('person')
            .selectAll('person')
            .$if(!!options.ownerId, (qb) => qb.where('person.ownerId', '=', options.ownerId))
            .$if(options.thumbnailPath !== undefined, (qb) => qb.where('person.thumbnailPath', '=', options.thumbnailPath))
            .$if(options.faceAssetId === null, (qb) => qb.where('person.faceAssetId', 'is', null))
            .$if(!!options.faceAssetId, (qb) => qb.where('person.faceAssetId', '=', options.faceAssetId))
            .$if(options.isHidden !== undefined, (qb) => qb.where('person.isHidden', '=', options.isHidden))
            .stream();
    }
    async getAllForUser(pagination, userId, options) {
        const items = await this.db
            .selectFrom('person')
            .selectAll('person')
            .innerJoin('asset_faces', 'asset_faces.personId', 'person.id')
            .innerJoin('assets', (join) => join
            .onRef('asset_faces.assetId', '=', 'assets.id')
            .on('assets.isArchived', '=', false)
            .on('assets.deletedAt', 'is', null))
            .where('person.ownerId', '=', userId)
            .where('asset_faces.deletedAt', 'is', null)
            .orderBy('person.isHidden', 'asc')
            .orderBy('person.isFavorite', 'desc')
            .having((eb) => eb.or([
            eb('person.name', '!=', ''),
            eb((innerEb) => innerEb.fn.count('asset_faces.assetId'), '>=', options?.minimumFaceCount || 1),
        ]))
            .groupBy('person.id')
            .$if(!!options?.closestFaceAssetId, (qb) => qb.orderBy((eb) => eb((eb) => eb
            .selectFrom('face_search')
            .select('face_search.embedding')
            .whereRef('face_search.faceId', '=', 'person.faceAssetId'), '<=>', (eb) => eb
            .selectFrom('face_search')
            .select('face_search.embedding')
            .where('face_search.faceId', '=', options.closestFaceAssetId))))
            .$if(!options?.closestFaceAssetId, (qb) => qb
            .orderBy((0, kysely_1.sql) `NULLIF(person.name, '') is null`, 'asc')
            .orderBy((eb) => eb.fn.count('asset_faces.assetId'), 'desc')
            .orderBy((0, kysely_1.sql) `NULLIF(person.name, '')`, (0, kysely_1.sql) `asc nulls last`)
            .orderBy('person.createdAt'))
            .$if(!options?.withHidden, (qb) => qb.where('person.isHidden', '=', false))
            .offset(pagination.skip ?? 0)
            .limit(pagination.take + 1)
            .execute();
        if (items.length > pagination.take) {
            return { items: items.slice(0, -1), hasNextPage: true };
        }
        return { items, hasNextPage: false };
    }
    getAllWithoutFaces() {
        return this.db
            .selectFrom('person')
            .selectAll('person')
            .leftJoin('asset_faces', 'asset_faces.personId', 'person.id')
            .where('asset_faces.deletedAt', 'is', null)
            .having((eb) => eb.fn.count('asset_faces.assetId'), '=', 0)
            .groupBy('person.id')
            .execute();
    }
    getFaces(assetId) {
        return this.db
            .selectFrom('asset_faces')
            .selectAll('asset_faces')
            .select(withPerson)
            .where('asset_faces.assetId', '=', assetId)
            .where('asset_faces.deletedAt', 'is', null)
            .orderBy('asset_faces.boundingBoxX1', 'asc')
            .execute();
    }
    getFaceById(id) {
        return this.db
            .selectFrom('asset_faces')
            .selectAll('asset_faces')
            .select(withPerson)
            .where('asset_faces.id', '=', id)
            .where('asset_faces.deletedAt', 'is', null)
            .executeTakeFirstOrThrow();
    }
    getFaceForFacialRecognitionJob(id) {
        return this.db
            .selectFrom('asset_faces')
            .select(['asset_faces.id', 'asset_faces.personId', 'asset_faces.sourceType'])
            .select((eb) => (0, postgres_1.jsonObjectFrom)(eb
            .selectFrom('assets')
            .select(['assets.ownerId', 'assets.isArchived', 'assets.fileCreatedAt'])
            .whereRef('assets.id', '=', 'asset_faces.assetId')).as('asset'))
            .select(withFaceSearch)
            .where('asset_faces.id', '=', id)
            .where('asset_faces.deletedAt', 'is', null)
            .executeTakeFirst();
    }
    getDataForThumbnailGenerationJob(id) {
        return this.db
            .selectFrom('person')
            .innerJoin('asset_faces', 'asset_faces.id', 'person.faceAssetId')
            .innerJoin('assets', 'asset_faces.assetId', 'assets.id')
            .innerJoin('exif', 'exif.assetId', 'assets.id')
            .innerJoin('asset_files', 'asset_files.assetId', 'assets.id')
            .select([
            'person.ownerId',
            'asset_faces.boundingBoxX1 as x1',
            'asset_faces.boundingBoxY1 as y1',
            'asset_faces.boundingBoxX2 as x2',
            'asset_faces.boundingBoxY2 as y2',
            'asset_faces.imageWidth as oldWidth',
            'asset_faces.imageHeight as oldHeight',
            'exif.exifImageWidth',
            'exif.exifImageHeight',
            'assets.type',
            'assets.originalPath',
            'asset_files.path as previewPath',
        ])
            .where('person.id', '=', id)
            .where('asset_faces.deletedAt', 'is', null)
            .where('asset_files.type', '=', enum_1.AssetFileType.PREVIEW)
            .where('exif.exifImageWidth', '>', 0)
            .where('exif.exifImageHeight', '>', 0)
            .$narrowType()
            .executeTakeFirst();
    }
    async reassignFace(assetFaceId, newPersonId) {
        const result = await this.db
            .updateTable('asset_faces')
            .set({ personId: newPersonId })
            .where('asset_faces.id', '=', assetFaceId)
            .executeTakeFirst();
        return Number(result.numChangedRows ?? 0);
    }
    getById(personId) {
        return this.db
            .selectFrom('person')
            .selectAll('person')
            .where('person.id', '=', personId)
            .executeTakeFirst();
    }
    getByName(userId, personName, { withHidden }) {
        return this.db
            .selectFrom('person')
            .selectAll('person')
            .where((eb) => eb.and([
            eb('person.ownerId', '=', userId),
            eb.or([
                eb(eb.fn('lower', ['person.name']), 'like', `${personName.toLowerCase()}%`),
                eb(eb.fn('lower', ['person.name']), 'like', `% ${personName.toLowerCase()}%`),
            ]),
        ]))
            .limit(1000)
            .$if(!withHidden, (qb) => qb.where('person.isHidden', '=', false))
            .execute();
    }
    getDistinctNames(userId, { withHidden }) {
        return this.db
            .selectFrom('person')
            .select(['person.id', 'person.name'])
            .distinctOn((eb) => eb.fn('lower', ['person.name']))
            .where((eb) => eb.and([eb('person.ownerId', '=', userId), eb('person.name', '!=', '')]))
            .$if(!withHidden, (qb) => qb.where('person.isHidden', '=', false))
            .execute();
    }
    async getStatistics(personId) {
        const result = await this.db
            .selectFrom('asset_faces')
            .leftJoin('assets', (join) => join
            .onRef('assets.id', '=', 'asset_faces.assetId')
            .on('asset_faces.personId', '=', personId)
            .on('assets.isArchived', '=', false)
            .on('assets.deletedAt', 'is', null))
            .select((eb) => eb.fn.count(eb.fn('distinct', ['assets.id'])).as('count'))
            .where('asset_faces.deletedAt', 'is', null)
            .executeTakeFirst();
        return {
            assets: result ? Number(result.count) : 0,
        };
    }
    async getNumberOfPeople(userId) {
        const items = await this.db
            .selectFrom('person')
            .innerJoin('asset_faces', 'asset_faces.personId', 'person.id')
            .where('person.ownerId', '=', userId)
            .where('asset_faces.deletedAt', 'is', null)
            .innerJoin('assets', (join) => join
            .onRef('assets.id', '=', 'asset_faces.assetId')
            .on('assets.deletedAt', 'is', null)
            .on('assets.isArchived', '=', false))
            .select((eb) => eb.fn.count(eb.fn('distinct', ['person.id'])).as('total'))
            .select((eb) => eb.fn
            .count(eb.fn('distinct', ['person.id']))
            .filterWhere('person.isHidden', '=', true)
            .as('hidden'))
            .executeTakeFirst();
        if (items == undefined) {
            return { total: 0, hidden: 0 };
        }
        return {
            total: Number(items.total),
            hidden: Number(items.hidden),
        };
    }
    create(person) {
        return this.db.insertInto('person').values(person).returningAll().executeTakeFirstOrThrow();
    }
    async createAll(people) {
        if (people.length === 0) {
            return [];
        }
        const results = await this.db.insertInto('person').values(people).returningAll().execute();
        return results.map(({ id }) => id);
    }
    async refreshFaces(facesToAdd, faceIdsToRemove, embeddingsToAdd) {
        let query = this.db;
        if (facesToAdd.length > 0) {
            query = query.with('added', (db) => db.insertInto('asset_faces').values(facesToAdd));
        }
        if (faceIdsToRemove.length > 0) {
            query = query.with('removed', (db) => db.deleteFrom('asset_faces').where('asset_faces.id', '=', (eb) => eb.fn.any(eb.val(faceIdsToRemove))));
        }
        if (embeddingsToAdd?.length) {
            query = query.with('added_embeddings', (db) => db.insertInto('face_search').values(embeddingsToAdd));
        }
        await query.selectFrom((0, kysely_1.sql) `(select 1)`.as('dummy')).execute();
    }
    async update(person) {
        return this.db
            .updateTable('person')
            .set(person)
            .where('person.id', '=', person.id)
            .returningAll()
            .executeTakeFirstOrThrow();
    }
    async updateAll(people) {
        if (people.length === 0) {
            return;
        }
        await this.db
            .insertInto('person')
            .values(people)
            .onConflict((oc) => oc.column('id').doUpdateSet((eb) => (0, database_1.removeUndefinedKeys)({
            name: eb.ref('excluded.name'),
            birthDate: eb.ref('excluded.birthDate'),
            thumbnailPath: eb.ref('excluded.thumbnailPath'),
            faceAssetId: eb.ref('excluded.faceAssetId'),
            isHidden: eb.ref('excluded.isHidden'),
            isFavorite: eb.ref('excluded.isFavorite'),
            color: eb.ref('excluded.color'),
        }, people[0])))
            .execute();
    }
    getFacesByIds(ids) {
        if (ids.length === 0) {
            return Promise.resolve([]);
        }
        const assetIds = [];
        const personIds = [];
        for (const { assetId, personId } of ids) {
            assetIds.push(assetId);
            personIds.push(personId);
        }
        return this.db
            .selectFrom('asset_faces')
            .selectAll('asset_faces')
            .select(withAsset)
            .select(withPerson)
            .where('asset_faces.assetId', 'in', assetIds)
            .where('asset_faces.personId', 'in', personIds)
            .where('asset_faces.deletedAt', 'is', null)
            .execute();
    }
    getRandomFace(personId) {
        return this.db
            .selectFrom('asset_faces')
            .selectAll('asset_faces')
            .where('asset_faces.personId', '=', personId)
            .where('asset_faces.deletedAt', 'is', null)
            .executeTakeFirst();
    }
    async getLatestFaceDate() {
        const result = (await this.db
            .selectFrom('asset_job_status')
            .select((eb) => (0, kysely_1.sql) `${eb.fn.max('asset_job_status.facesRecognizedAt')}::text`.as('latestDate'))
            .executeTakeFirst());
        return result?.latestDate;
    }
    async createAssetFace(face) {
        await this.db.insertInto('asset_faces').values(face).execute();
    }
    async deleteAssetFace(id) {
        await this.db.deleteFrom('asset_faces').where('asset_faces.id', '=', id).execute();
    }
    async softDeleteAssetFaces(id) {
        await this.db.updateTable('asset_faces').set({ deletedAt: new Date() }).where('asset_faces.id', '=', id).execute();
    }
    async vacuum({ reindexVectors }) {
        await (0, kysely_1.sql) `VACUUM ANALYZE asset_faces, face_search, person`.execute(this.db);
        await (0, kysely_1.sql) `REINDEX TABLE asset_faces`.execute(this.db);
        await (0, kysely_1.sql) `REINDEX TABLE person`.execute(this.db);
        if (reindexVectors) {
            await (0, kysely_1.sql) `REINDEX TABLE face_search`.execute(this.db);
        }
    }
};
exports.PersonRepository = PersonRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ oldPersonId: decorators_1.DummyValue.UUID, newPersonId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "reassignFaces", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ sourceType: enum_1.SourceType.EXIF }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "unassignFaces", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ sourceType: enum_1.SourceType.EXIF }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "deleteFaces", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getAllWithoutFaces", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getFaces", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getFaceById", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getFaceForFacialRecognitionJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getDataForThumbnailGenerationJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "reassignFace", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.STRING, { withHidden: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Object]),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getByName", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { withHidden: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "getDistinctNames", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "getStatistics", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "getNumberOfPeople", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[], [], [{ faceId: decorators_1.DummyValue.UUID, embedding: decorators_1.DummyValue.VECTOR }]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Array, Array]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "refreshFaces", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[{ assetId: decorators_1.DummyValue.UUID, personId: decorators_1.DummyValue.UUID }]] }),
    (0, decorators_1.ChunkedArray)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getFacesByIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PersonRepository.prototype, "getRandomFace", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "getLatestFaceDate", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "deleteAssetFace", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PersonRepository.prototype, "softDeleteAssetFaces", null);
exports.PersonRepository = PersonRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], PersonRepository);
//# sourceMappingURL=person.repository.js.map