import { Insertable, Kysely, Selectable, Updateable } from 'kysely';
import { AssetFaces, DB, FaceSearch, Person } from 'src/db';
import { SourceType } from 'src/enum';
import { PaginationOptions } from 'src/utils/pagination';
export interface PersonSearchOptions {
    minimumFaceCount: number;
    withHidden: boolean;
    closestFaceAssetId?: string;
}
export interface PersonNameSearchOptions {
    withHidden?: boolean;
}
export interface PersonNameResponse {
    id: string;
    name: string;
}
export interface AssetFaceId {
    assetId: string;
    personId: string;
}
export interface UpdateFacesData {
    oldPersonId?: string;
    faceIds?: string[];
    newPersonId: string;
}
export interface PersonStatistics {
    assets: number;
}
export interface PeopleStatistics {
    total: number;
    hidden: number;
}
export interface DeleteFacesOptions {
    sourceType: SourceType;
}
export interface GetAllPeopleOptions {
    ownerId?: string;
    thumbnailPath?: string;
    faceAssetId?: string | null;
    isHidden?: boolean;
}
export interface GetAllFacesOptions {
    personId?: string | null;
    assetId?: string;
    sourceType?: SourceType;
}
export type UnassignFacesOptions = DeleteFacesOptions;
export type SelectFaceOptions = (keyof Selectable<AssetFaces>)[];
export declare class PersonRepository {
    private db;
    constructor(db: Kysely<DB>);
    reassignFaces({ oldPersonId, faceIds, newPersonId }: UpdateFacesData): Promise<number>;
    unassignFaces({ sourceType }: UnassignFacesOptions): Promise<void>;
    delete(ids: string[]): Promise<void>;
    deleteFaces({ sourceType }: DeleteFacesOptions): Promise<void>;
    getAllFaces(options?: GetAllFacesOptions): AsyncIterableIterator<{
        id: string;
        assetId: string;
        imageHeight: number;
        imageWidth: number;
        boundingBoxX1: number;
        boundingBoxX2: number;
        boundingBoxY1: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        personId: string | null;
        deletedAt: Date | null;
    } & Partial<Omit<unknown, "id" | "assetId" | "imageHeight" | "imageWidth" | "boundingBoxX1" | "boundingBoxX2" | "boundingBoxY1" | "boundingBoxY2" | "sourceType" | "personId" | "deletedAt">>>;
    getAll(options?: GetAllPeopleOptions): AsyncIterableIterator<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        birthDate: Date | null;
        isHidden: boolean;
        isFavorite: boolean;
        color: string | null;
        ownerId: string;
        createdAt: Date;
        faceAssetId: string | null;
        thumbnailPath: string;
    } & Partial<Omit<unknown, "name" | "id" | "updateId" | "updatedAt" | "birthDate" | "isHidden" | "isFavorite" | "color" | "ownerId" | "createdAt" | "faceAssetId" | "thumbnailPath">>>;
    getAllForUser(pagination: PaginationOptions, userId: string, options?: PersonSearchOptions): Promise<{
        items: {
            name: string;
            id: string;
            updateId: string;
            updatedAt: Date;
            birthDate: Date | null;
            isHidden: boolean;
            isFavorite: boolean;
            color: string | null;
            ownerId: string;
            createdAt: Date;
            faceAssetId: string | null;
            thumbnailPath: string;
        }[];
        hasNextPage: boolean;
    }>;
    getAllWithoutFaces(): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        birthDate: Date | null;
        isHidden: boolean;
        isFavorite: boolean;
        color: string | null;
        ownerId: string;
        createdAt: Date;
        faceAssetId: string | null;
        thumbnailPath: string;
    }[]>;
    getFaces(assetId: string): Promise<{
        id: string;
        assetId: string;
        imageHeight: number;
        imageWidth: number;
        boundingBoxX1: number;
        boundingBoxX2: number;
        boundingBoxY1: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        personId: string | null;
        deletedAt: Date | null;
        person: {
            name: string;
            id: string;
            updateId: string;
            updatedAt: Date;
            birthDate: Date | null;
            isHidden: boolean;
            isFavorite: boolean;
            color: string | null;
            ownerId: string;
            createdAt: Date;
            faceAssetId: string | null;
            thumbnailPath: string;
        } | null;
    }[]>;
    getFaceById(id: string): Promise<{
        id: string;
        assetId: string;
        imageHeight: number;
        imageWidth: number;
        boundingBoxX1: number;
        boundingBoxX2: number;
        boundingBoxY1: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        personId: string | null;
        deletedAt: Date | null;
        person: {
            name: string;
            id: string;
            updateId: string;
            updatedAt: Date;
            birthDate: Date | null;
            isHidden: boolean;
            isFavorite: boolean;
            color: string | null;
            ownerId: string;
            createdAt: Date;
            faceAssetId: string | null;
            thumbnailPath: string;
        } | null;
    }>;
    getFaceForFacialRecognitionJob(id: string): Promise<{
        id: string;
        sourceType: SourceType;
        personId: string | null;
        asset: {
            fileCreatedAt: Date;
            ownerId: string;
            isArchived: boolean;
        } | null;
        faceSearch: {
            embedding: string;
            faceId: string;
        } | null;
    } | undefined>;
    getDataForThumbnailGenerationJob(id: string): Promise<{
        type: import("src/enum").AssetType;
        exifImageHeight: number;
        exifImageWidth: number;
        ownerId: string;
        originalPath: string;
        previewPath: string;
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        oldWidth: number;
        oldHeight: number;
    } | undefined>;
    reassignFace(assetFaceId: string, newPersonId: string): Promise<number>;
    getById(personId: string): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        birthDate: Date | null;
        isHidden: boolean;
        isFavorite: boolean;
        color: string | null;
        ownerId: string;
        createdAt: Date;
        faceAssetId: string | null;
        thumbnailPath: string;
    } | undefined>;
    getByName(userId: string, personName: string, { withHidden }: PersonNameSearchOptions): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        birthDate: Date | null;
        isHidden: boolean;
        isFavorite: boolean;
        color: string | null;
        ownerId: string;
        createdAt: Date;
        faceAssetId: string | null;
        thumbnailPath: string;
    }[]>;
    getDistinctNames(userId: string, { withHidden }: PersonNameSearchOptions): Promise<PersonNameResponse[]>;
    getStatistics(personId: string): Promise<PersonStatistics>;
    getNumberOfPeople(userId: string): Promise<PeopleStatistics>;
    create(person: Insertable<Person>): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        birthDate: Date | null;
        isHidden: boolean;
        isFavorite: boolean;
        color: string | null;
        ownerId: string;
        createdAt: Date;
        faceAssetId: string | null;
        thumbnailPath: string;
    }>;
    createAll(people: Insertable<Person>[]): Promise<string[]>;
    refreshFaces(facesToAdd: (Insertable<AssetFaces> & {
        assetId: string;
    })[], faceIdsToRemove: string[], embeddingsToAdd?: Insertable<FaceSearch>[]): Promise<void>;
    update(person: Updateable<Person> & {
        id: string;
    }): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        birthDate: Date | null;
        isHidden: boolean;
        isFavorite: boolean;
        color: string | null;
        ownerId: string;
        createdAt: Date;
        faceAssetId: string | null;
        thumbnailPath: string;
    }>;
    updateAll(people: Insertable<Person>[]): Promise<void>;
    getFacesByIds(ids: AssetFaceId[]): Promise<{
        id: string;
        assetId: string;
        imageHeight: number;
        imageWidth: number;
        boundingBoxX1: number;
        boundingBoxX2: number;
        boundingBoxY1: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        personId: string | null;
        deletedAt: Date | null;
        asset: {
            id: string;
            type: import("src/enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("src/enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        } | null;
        person: {
            name: string;
            id: string;
            updateId: string;
            updatedAt: Date;
            birthDate: Date | null;
            isHidden: boolean;
            isFavorite: boolean;
            color: string | null;
            ownerId: string;
            createdAt: Date;
            faceAssetId: string | null;
            thumbnailPath: string;
        } | null;
    }[]>;
    getRandomFace(personId: string): Promise<{
        id: string;
        assetId: string;
        imageHeight: number;
        imageWidth: number;
        boundingBoxX1: number;
        boundingBoxX2: number;
        boundingBoxY1: number;
        boundingBoxY2: number;
        sourceType: SourceType;
        personId: string | null;
        deletedAt: Date | null;
    } | undefined>;
    getLatestFaceDate(): Promise<string | undefined>;
    createAssetFace(face: Insertable<AssetFaces>): Promise<void>;
    deleteAssetFace(id: string): Promise<void>;
    softDeleteAssetFaces(id: string): Promise<void>;
    private vacuum;
}
