import { Insertable, Kysely, Updateable } from 'kysely';
import { DB, Partners } from 'src/db';
export interface PartnerIds {
    sharedById: string;
    sharedWithId: string;
}
export declare enum PartnerDirection {
    SharedBy = "shared-by",
    SharedWith = "shared-with"
}
export declare class PartnerRepository {
    private db;
    constructor(db: Kysely<DB>);
    getAll(userId: string): Promise<{
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        inTimeline: boolean;
        sharedById: string;
        sharedWithId: string;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        } | null;
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        } | null;
    }[]>;
    get({ sharedWithId, sharedById }: PartnerIds): Promise<{
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        inTimeline: boolean;
        sharedById: string;
        sharedWithId: string;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        } | null;
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        } | null;
    } | undefined>;
    create(values: Insertable<Partners>): Promise<{
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        inTimeline: boolean;
        sharedById: string;
        sharedWithId: string;
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
    }>;
    update({ sharedWithId, sharedById }: PartnerIds, values: Updateable<Partners>): Promise<{
        updateId: string;
        updatedAt: Date;
        createdAt: Date;
        sharedBy: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
        inTimeline: boolean;
        sharedById: string;
        sharedWithId: string;
        sharedWith: {
            name: string;
            id: string;
            email: string;
            profileImagePath: string;
            profileChangedAt: Date;
        };
    }>;
    remove({ sharedWithId, sharedById }: PartnerIds): Promise<void>;
    private builder;
}
