"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var OAuthRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuthRepository = void 0;
const common_1 = require("@nestjs/common");
const logging_repository_1 = require("./logging.repository");
let OAuthRepository = OAuthRepository_1 = class OAuthRepository {
    logger;
    constructor(logger) {
        this.logger = logger;
        this.logger.setContext(OAuthRepository_1.name);
    }
    async authorize(config, redirectUrl, state, codeChallenge) {
        const { buildAuthorizationUrl, randomState, randomPKCECodeVerifier, calculatePKCECodeChallenge } = await import('openid-client');
        const client = await this.getClient(config);
        state ??= randomState();
        let codeVerifier;
        if (codeChallenge) {
            codeVerifier = null;
        }
        else {
            codeVerifier = randomPKCECodeVerifier();
            codeChallenge = await calculatePKCECodeChallenge(codeVerifier);
        }
        const url = buildAuthorizationUrl(client, {
            redirect_uri: redirectUrl,
            scope: config.scope,
            state,
            code_challenge: codeChallenge,
            code_challenge_method: 'S256',
        }).toString();
        return { url, state, codeVerifier };
    }
    async getLogoutEndpoint(config) {
        const client = await this.getClient(config);
        return client.serverMetadata().end_session_endpoint;
    }
    async getProfile(config, url, expectedState, codeVerifier) {
        const { authorizationCodeGrant, fetchUserInfo, ...oidc } = await import('openid-client');
        const client = await this.getClient(config);
        const pkceCodeVerifier = client.serverMetadata().supportsPKCE() ? codeVerifier : undefined;
        try {
            const tokens = await authorizationCodeGrant(client, new URL(url), { expectedState, pkceCodeVerifier });
            const profile = await fetchUserInfo(client, tokens.access_token, oidc.skipSubjectCheck);
            if (!profile.sub) {
                throw new Error('Unexpected profile response, no `sub`');
            }
            return profile;
        }
        catch (error) {
            if (error.message.includes('unexpected JWT alg received')) {
                this.logger.warn([
                    'Algorithm mismatch. Make sure the signing algorithm is set correctly in the OAuth settings.',
                    'Or, that you have specified a signing key in your OAuth provider.',
                ].join(' '));
            }
            if (error.code === 'OAUTH_INVALID_RESPONSE') {
                this.logger.warn(`Invalid response from authorization server. Cause: ${error.cause?.message}`);
                throw error.cause;
            }
            throw error;
        }
    }
    async getProfilePicture(url) {
        const response = await fetch(url);
        if (!response.ok) {
            throw new Error(`Failed to fetch picture: ${response.statusText}`);
        }
        return {
            data: await response.arrayBuffer(),
            contentType: response.headers.get('content-type'),
        };
    }
    async getClient({ issuerUrl, clientId, clientSecret, profileSigningAlgorithm, signingAlgorithm, }) {
        try {
            const { allowInsecureRequests, discovery } = await import('openid-client');
            return await discovery(new URL(issuerUrl), clientId, {
                client_secret: clientSecret,
                response_types: ['code'],
                userinfo_signed_response_alg: profileSigningAlgorithm === 'none' ? undefined : profileSigningAlgorithm,
                id_token_signed_response_alg: signingAlgorithm,
                timeout: 30_000,
            }, undefined, { execute: [allowInsecureRequests] });
        }
        catch (error) {
            this.logger.error(`Error in OAuth discovery: ${error}`, error?.stack, error?.errors);
            throw new common_1.InternalServerErrorException(`Error in OAuth discovery: ${error}`, { cause: error });
        }
    }
};
exports.OAuthRepository = OAuthRepository;
exports.OAuthRepository = OAuthRepository = OAuthRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository])
], OAuthRepository);
//# sourceMappingURL=oauth.repository.js.map