import type { UserInfoResponse } from 'openid-client' with { 'resolution-mode': 'import' };
import { LoggingRepository } from 'src/repositories/logging.repository';
export type OAuthConfig = {
    clientId: string;
    clientSecret: string;
    issuerUrl: string;
    mobileOverrideEnabled: boolean;
    mobileRedirectUri: string;
    profileSigningAlgorithm: string;
    scope: string;
    signingAlgorithm: string;
};
export type OAuthProfile = UserInfoResponse;
export declare class OAuthRepository {
    private logger;
    constructor(logger: LoggingRepository);
    authorize(config: OAuthConfig, redirectUrl: string, state?: string, codeChallenge?: string): Promise<{
        url: string;
        state: string;
        codeVerifier: string | null;
    }>;
    getLogoutEndpoint(config: OAuthConfig): Promise<string | undefined>;
    getProfile(config: OAuthConfig, url: string, expectedState: string, codeVerifier: string): Promise<OAuthProfile>;
    getProfilePicture(url: string): Promise<{
        data: ArrayBuffer;
        contentType: string | null;
    }>;
    private getClient;
}
