import { Insertable, Kysely, Updateable } from 'kysely';
import { DB, MoveHistory } from 'src/db';
import { PathType } from 'src/enum';
export declare class MoveRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(entity: Insertable<MoveHistory>): Promise<{
        id: string;
        entityId: string;
        newPath: string;
        oldPath: string;
        pathType: string;
    }>;
    getByEntity(entityId: string, pathType: PathType): Promise<{
        id: string;
        entityId: string;
        newPath: string;
        oldPath: string;
        pathType: string;
    } | undefined>;
    update(id: string, entity: Updateable<MoveHistory>): Promise<{
        id: string;
        entityId: string;
        newPath: string;
        oldPath: string;
        pathType: string;
    }>;
    delete(id: string): Promise<{
        id: string;
        entityId: string;
        newPath: string;
        oldPath: string;
        pathType: string;
    }>;
    cleanMoveHistory(): Promise<void>;
    cleanMoveHistorySingle(assetId: string): Promise<void>;
}
