"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const luxon_1 = require("luxon");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const memory_dto_1 = require("../dtos/memory.dto");
let MemoryRepository = class MemoryRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    cleanup() {
        return this.db
            .deleteFrom('memories')
            .where('createdAt', '<', luxon_1.DateTime.now().minus({ days: 30 }).toJSDate())
            .where('isSaved', '=', false)
            .execute();
    }
    search(ownerId, dto) {
        return this.db
            .selectFrom('memories')
            .selectAll('memories')
            .select((eb) => (0, postgres_1.jsonArrayFrom)(eb
            .selectFrom('assets')
            .selectAll('assets')
            .innerJoin('memories_assets_assets', 'assets.id', 'memories_assets_assets.assetsId')
            .whereRef('memories_assets_assets.memoriesId', '=', 'memories.id')
            .orderBy('assets.fileCreatedAt', 'asc')
            .where('assets.deletedAt', 'is', null)).as('assets'))
            .$if(dto.isSaved !== undefined, (qb) => qb.where('isSaved', '=', dto.isSaved))
            .$if(dto.type !== undefined, (qb) => qb.where('type', '=', dto.type))
            .$if(dto.for !== undefined, (qb) => qb
            .where((where) => where.or([where('showAt', 'is', null), where('showAt', '<=', dto.for)]))
            .where((where) => where.or([where('hideAt', 'is', null), where('hideAt', '>=', dto.for)])))
            .where('deletedAt', dto.isTrashed ? 'is not' : 'is', null)
            .where('ownerId', '=', ownerId)
            .orderBy('memoryAt', 'desc')
            .execute();
    }
    get(id) {
        return this.getByIdBuilder(id).executeTakeFirst();
    }
    async create(memory, assetIds) {
        const id = await this.db.transaction().execute(async (tx) => {
            const { id } = await tx.insertInto('memories').values(memory).returning('id').executeTakeFirstOrThrow();
            if (assetIds.size > 0) {
                const values = [...assetIds].map((assetId) => ({ memoriesId: id, assetsId: assetId }));
                await tx.insertInto('memories_assets_assets').values(values).execute();
            }
            return id;
        });
        return this.getByIdBuilder(id).executeTakeFirstOrThrow();
    }
    async update(id, memory) {
        await this.db.updateTable('memories').set(memory).where('id', '=', id).execute();
        return this.getByIdBuilder(id).executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('memories').where('id', '=', id).execute();
    }
    async getAssetIds(id, assetIds) {
        if (assetIds.length === 0) {
            return new Set();
        }
        const results = await this.db
            .selectFrom('memories_assets_assets')
            .select(['assetsId'])
            .where('memoriesId', '=', id)
            .where('assetsId', 'in', assetIds)
            .execute();
        return new Set(results.map(({ assetsId }) => assetsId));
    }
    async addAssetIds(id, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db
            .insertInto('memories_assets_assets')
            .values(assetIds.map((assetId) => ({ memoriesId: id, assetsId: assetId })))
            .execute();
    }
    async removeAssetIds(id, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db
            .deleteFrom('memories_assets_assets')
            .where('memoriesId', '=', id)
            .where('assetsId', 'in', assetIds)
            .execute();
    }
    getByIdBuilder(id) {
        return this.db
            .selectFrom('memories')
            .selectAll('memories')
            .select((eb) => (0, postgres_1.jsonArrayFrom)(eb
            .selectFrom('assets')
            .selectAll('assets')
            .innerJoin('memories_assets_assets', 'assets.id', 'memories_assets_assets.assetsId')
            .whereRef('memories_assets_assets.memoriesId', '=', 'memories.id')
            .orderBy('assets.fileCreatedAt', 'asc')
            .where('assets.deletedAt', 'is', null)).as('assets'))
            .where('id', '=', id)
            .where('deletedAt', 'is', null);
    }
};
exports.MemoryRepository = MemoryRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MemoryRepository.prototype, "cleanup", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, {}] }, { name: 'date filter', params: [decorators_1.DummyValue.UUID, { for: decorators_1.DummyValue.DATE }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, memory_dto_1.MemorySearchDto]),
    __metadata("design:returntype", void 0)
], MemoryRepository.prototype, "search", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MemoryRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { ownerId: decorators_1.DummyValue.UUID, isSaved: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "update", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "getAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "addAssetIds", null);
__decorate([
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], MemoryRepository.prototype, "removeAssetIds", null);
exports.MemoryRepository = MemoryRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], MemoryRepository);
//# sourceMappingURL=memory.repository.js.map