import { Insertable, Kysely, Updateable } from 'kysely';
import { DB, Memories } from 'src/db';
import { MemorySearchDto } from 'src/dtos/memory.dto';
import { IBulkAsset } from 'src/types';
export declare class MemoryRepository implements IBulkAsset {
    private db;
    constructor(db: Kysely<DB>);
    cleanup(): Promise<import("kysely").DeleteResult[]>;
    search(ownerId: string, dto: MemorySearchDto): Promise<{
        data: import("src/types").OnThisDayData;
        id: string;
        type: import("../enum").MemoryType;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        hideAt: Date | null;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[];
    }[]>;
    get(id: string): Promise<{
        data: import("src/types").OnThisDayData;
        id: string;
        type: import("../enum").MemoryType;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        hideAt: Date | null;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[];
    } | undefined>;
    create(memory: Insertable<Memories>, assetIds: Set<string>): Promise<{
        data: import("src/types").OnThisDayData;
        id: string;
        type: import("../enum").MemoryType;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        hideAt: Date | null;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[];
    }>;
    update(id: string, memory: Updateable<Memories>): Promise<{
        data: import("src/types").OnThisDayData;
        id: string;
        type: import("../enum").MemoryType;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        hideAt: Date | null;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updateId: string;
            updatedAt: Date;
            isFavorite: boolean;
            deletedAt: Date | null;
            ownerId: string;
            libraryId: string | null;
            createdAt: Date;
            status: import("../enum").AssetStatus;
            checksum: Buffer<ArrayBufferLike>;
            deviceAssetId: string;
            deviceId: string;
            duplicateId: string | null;
            duration: string | null;
            encodedVideoPath: string | null;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isArchived: boolean;
            isExternal: boolean;
            isOffline: boolean;
            isVisible: boolean;
            livePhotoVideoId: string | null;
            localDateTime: Date;
            originalFileName: string;
            originalPath: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            stackId: string | null;
        }[];
    }>;
    delete(id: string): Promise<void>;
    getAssetIds(id: string, assetIds: string[]): Promise<Set<string>>;
    addAssetIds(id: string, assetIds: string[]): Promise<void>;
    removeAssetIds(id: string, assetIds: string[]): Promise<void>;
    private getByIdBuilder;
}
