import { Writable } from 'node:stream';
import sharp from 'sharp';
import { Exif } from 'src/database';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { DecodeToBufferOptions, GenerateThumbhashOptions, GenerateThumbnailOptions, ImageDimensions, ProbeOptions, TranscodeCommand, VideoInfo } from 'src/types';
export declare class MediaRepository {
    private logger;
    constructor(logger: LoggingRepository);
    extract(input: string, output: string): Promise<boolean>;
    writeExif(tags: Partial<Exif>, output: string): Promise<boolean>;
    decodeImage(input: string, options: DecodeToBufferOptions): Promise<{
        data: Buffer;
        info: sharp.OutputInfo;
    }>;
    generateThumbnail(input: string | Buffer, options: GenerateThumbnailOptions, output: string): Promise<void>;
    private getImageDecodingPipeline;
    generateThumbhash(input: string | Buffer, options: GenerateThumbhashOptions): Promise<Buffer>;
    probe(input: string, options?: ProbeOptions): Promise<VideoInfo>;
    transcode(input: string, output: string | Writable, options: TranscodeCommand): Promise<void>;
    getImageDimensions(input: string): Promise<ImageDimensions>;
    private configureFfmpegCall;
    private parseInt;
    private parseFloat;
}
