import { Kysely } from 'kysely';
import { DB, GeodataPlaces, NaturalearthCountries } from 'src/db';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
export interface MapMarkerSearchOptions {
    isArchived?: boolean;
    isFavorite?: boolean;
    fileCreatedBefore?: Date;
    fileCreatedAfter?: Date;
}
export interface GeoPoint {
    latitude: number;
    longitude: number;
}
export interface ReverseGeocodeResult {
    country: string | null;
    state: string | null;
    city: string | null;
}
export interface MapMarker extends ReverseGeocodeResult {
    id: string;
    lat: number;
    lon: number;
}
interface MapDB extends DB {
    geodata_places_tmp: GeodataPlaces;
    naturalearth_countries_tmp: NaturalearthCountries;
}
export declare class MapRepository {
    private configRepository;
    private metadataRepository;
    private logger;
    private db;
    constructor(configRepository: ConfigRepository, metadataRepository: SystemMetadataRepository, logger: LoggingRepository, db: Kysely<MapDB>);
    init(): Promise<void>;
    getMapMarkers(ownerIds: string[], albumIds: string[], options?: MapMarkerSearchOptions): Promise<{
        id: string;
        state: string | null;
        city: string | null;
        country: string | null;
        lat: number;
        lon: number;
    }[]>;
    reverseGeocode(point: GeoPoint): Promise<ReverseGeocodeResult>;
    private importNaturalEarthCountries;
    private importGeodata;
    private loadCities500;
    private loadAdmin;
    private createGeodataIndices;
}
export {};
