"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MachineLearningRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MachineLearningRepository = exports.ModelType = exports.ModelTask = void 0;
const common_1 = require("@nestjs/common");
const promises_1 = require("node:fs/promises");
const constants_1 = require("../constants");
const logging_repository_1 = require("./logging.repository");
var ModelTask;
(function (ModelTask) {
    ModelTask["FACIAL_RECOGNITION"] = "facial-recognition";
    ModelTask["SEARCH"] = "clip";
})(ModelTask || (exports.ModelTask = ModelTask = {}));
var ModelType;
(function (ModelType) {
    ModelType["DETECTION"] = "detection";
    ModelType["PIPELINE"] = "pipeline";
    ModelType["RECOGNITION"] = "recognition";
    ModelType["TEXTUAL"] = "textual";
    ModelType["VISUAL"] = "visual";
})(ModelType || (exports.ModelType = ModelType = {}));
let MachineLearningRepository = MachineLearningRepository_1 = class MachineLearningRepository {
    logger;
    urlAvailability;
    constructor(logger) {
        this.logger = logger;
        this.logger.setContext(MachineLearningRepository_1.name);
        this.urlAvailability = {};
    }
    setUrlAvailability(url, active) {
        const current = this.urlAvailability[url];
        if (current?.active !== active) {
            this.logger.verbose(`Setting ${url} ML server to ${active ? 'active' : 'inactive'}.`);
        }
        this.urlAvailability[url] = {
            active,
            lastChecked: Date.now(),
        };
    }
    async checkAvailability(url) {
        let active = false;
        try {
            const response = await fetch(new URL('/ping', url), {
                signal: AbortSignal.timeout(constants_1.MACHINE_LEARNING_PING_TIMEOUT),
            });
            active = response.ok;
        }
        catch {
        }
        this.setUrlAvailability(url, active);
        return active;
    }
    async shouldSkipUrl(url) {
        const availability = this.urlAvailability[url];
        if (availability === undefined) {
            if (!(await this.checkAvailability(url))) {
                return true;
            }
            return false;
        }
        if (!availability.active && Date.now() - availability.lastChecked < constants_1.MACHINE_LEARNING_AVAILABILITY_BACKOFF_TIME) {
            void this.checkAvailability(url);
            return true;
        }
        return false;
    }
    async predict(urls, payload, config) {
        const formData = await this.getFormData(payload, config);
        let urlCounter = 0;
        for (const url of urls) {
            urlCounter++;
            const isLast = urlCounter >= urls.length;
            if (!isLast && (await this.shouldSkipUrl(url))) {
                continue;
            }
            try {
                const response = await fetch(new URL('/predict', url), { method: 'POST', body: formData });
                if (response.ok) {
                    this.setUrlAvailability(url, true);
                    return response.json();
                }
                this.logger.warn(`Machine learning request to "${url}" failed with status ${response.status}: ${response.statusText}`);
            }
            catch (error) {
                this.logger.warn(`Machine learning request to "${url}" failed: ${error instanceof Error ? error.message : error}`);
            }
            this.setUrlAvailability(url, false);
        }
        throw new Error(`Machine learning request '${JSON.stringify(config)}' failed for all URLs`);
    }
    async detectFaces(urls, imagePath, { modelName, minScore }) {
        const request = {
            [ModelTask.FACIAL_RECOGNITION]: {
                [ModelType.DETECTION]: { modelName, options: { minScore } },
                [ModelType.RECOGNITION]: { modelName },
            },
        };
        const response = await this.predict(urls, { imagePath }, request);
        return {
            imageHeight: response.imageHeight,
            imageWidth: response.imageWidth,
            faces: response[ModelTask.FACIAL_RECOGNITION],
        };
    }
    async encodeImage(urls, imagePath, { modelName }) {
        const request = { [ModelTask.SEARCH]: { [ModelType.VISUAL]: { modelName } } };
        const response = await this.predict(urls, { imagePath }, request);
        return response[ModelTask.SEARCH];
    }
    async encodeText(urls, text, { language, modelName }) {
        const request = { [ModelTask.SEARCH]: { [ModelType.TEXTUAL]: { modelName, options: { language } } } };
        const response = await this.predict(urls, { text }, request);
        return response[ModelTask.SEARCH];
    }
    async getFormData(payload, config) {
        const formData = new FormData();
        formData.append('entries', JSON.stringify(config));
        if ('imagePath' in payload) {
            formData.append('image', new Blob([await (0, promises_1.readFile)(payload.imagePath)]));
        }
        else if ('text' in payload) {
            formData.append('text', payload.text);
        }
        else {
            throw new Error('Invalid input');
        }
        return formData;
    }
};
exports.MachineLearningRepository = MachineLearningRepository;
exports.MachineLearningRepository = MachineLearningRepository = MachineLearningRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository])
], MachineLearningRepository);
//# sourceMappingURL=machine-learning.repository.js.map