import { CLIPConfig } from 'src/dtos/model-config.dto';
import { LoggingRepository } from 'src/repositories/logging.repository';
export interface BoundingBox {
    x1: number;
    y1: number;
    x2: number;
    y2: number;
}
export declare enum ModelTask {
    FACIAL_RECOGNITION = "facial-recognition",
    SEARCH = "clip"
}
export declare enum ModelType {
    DETECTION = "detection",
    PIPELINE = "pipeline",
    RECOGNITION = "recognition",
    TEXTUAL = "textual",
    VISUAL = "visual"
}
export type ModelPayload = {
    imagePath: string;
} | {
    text: string;
};
type ModelOptions = {
    modelName: string;
};
export type FaceDetectionOptions = ModelOptions & {
    minScore: number;
};
type VisualResponse = {
    imageHeight: number;
    imageWidth: number;
};
export type ClipVisualRequest = {
    [ModelTask.SEARCH]: {
        [ModelType.VISUAL]: ModelOptions;
    };
};
export type ClipVisualResponse = {
    [ModelTask.SEARCH]: string;
} & VisualResponse;
export type ClipTextualRequest = {
    [ModelTask.SEARCH]: {
        [ModelType.TEXTUAL]: ModelOptions;
    };
};
export type ClipTextualResponse = {
    [ModelTask.SEARCH]: string;
};
export type FacialRecognitionRequest = {
    [ModelTask.FACIAL_RECOGNITION]: {
        [ModelType.DETECTION]: ModelOptions & {
            options: {
                minScore: number;
            };
        };
        [ModelType.RECOGNITION]: ModelOptions;
    };
};
export interface Face {
    boundingBox: BoundingBox;
    embedding: string;
    score: number;
}
export type FacialRecognitionResponse = {
    [ModelTask.FACIAL_RECOGNITION]: Face[];
} & VisualResponse;
export type DetectedFaces = {
    faces: Face[];
} & VisualResponse;
export type MachineLearningRequest = ClipVisualRequest | ClipTextualRequest | FacialRecognitionRequest;
export type TextEncodingOptions = ModelOptions & {
    language?: string;
};
export declare class MachineLearningRepository {
    private logger;
    private urlAvailability;
    constructor(logger: LoggingRepository);
    private setUrlAvailability;
    private checkAvailability;
    private shouldSkipUrl;
    private predict;
    detectFaces(urls: string[], imagePath: string, { modelName, minScore }: FaceDetectionOptions): Promise<{
        imageHeight: number;
        imageWidth: number;
        faces: Face[];
    }>;
    encodeImage(urls: string[], imagePath: string, { modelName }: CLIPConfig): Promise<string>;
    encodeText(urls: string[], text: string, { language, modelName }: TextEncodingOptions): Promise<string>;
    private getFormData;
}
export {};
