import { ConsoleLogger } from '@nestjs/common';
import { ClsService } from 'nestjs-cls';
import { LogLevel } from 'src/enum';
import { ConfigRepository } from 'src/repositories/config.repository';
type LogDetails = any[];
type LogFunction = () => string;
export declare class MyConsoleLogger extends ConsoleLogger {
    private cls;
    private isColorEnabled;
    constructor(cls: ClsService | undefined, options?: {
        color?: boolean;
        context?: string;
    });
    isLevelEnabled(level: LogLevel): boolean;
    formatContext(context: string): string;
    private colors;
    private withColor;
}
export declare class LoggingRepository {
    private logger;
    constructor(cls: ClsService | undefined, configRepository: ConfigRepository | undefined);
    static create(): LoggingRepository;
    setAppName(name: string): void;
    setContext(context: string): void;
    isLevelEnabled(level: LogLevel): boolean;
    setLogLevel(level: LogLevel | false): void;
    verbose(message: string, ...details: LogDetails): void;
    verboseFn(message: LogFunction, ...details: LogDetails): void;
    debug(message: string, ...details: LogDetails): void;
    debugFn(message: LogFunction, ...details: LogDetails): void;
    log(message: string, ...details: LogDetails): void;
    warn(message: string, ...details: LogDetails): void;
    error(message: string | Error, ...details: LogDetails): void;
    fatal(message: string, ...details: LogDetails): void;
    private handleFunction;
    private handleMessage;
}
export {};
