"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryRepository = exports.AssetSyncResult = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
var AssetSyncResult;
(function (AssetSyncResult) {
    AssetSyncResult[AssetSyncResult["DO_NOTHING"] = 0] = "DO_NOTHING";
    AssetSyncResult[AssetSyncResult["UPDATE"] = 1] = "UPDATE";
    AssetSyncResult[AssetSyncResult["OFFLINE"] = 2] = "OFFLINE";
    AssetSyncResult[AssetSyncResult["CHECK_OFFLINE"] = 3] = "CHECK_OFFLINE";
})(AssetSyncResult || (exports.AssetSyncResult = AssetSyncResult = {}));
let LibraryRepository = class LibraryRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    get(id, withDeleted = false) {
        return this.db
            .selectFrom('libraries')
            .selectAll('libraries')
            .where('libraries.id', '=', id)
            .$if(!withDeleted, (qb) => qb.where('libraries.deletedAt', 'is', null))
            .executeTakeFirst();
    }
    getAll(withDeleted = false) {
        return this.db
            .selectFrom('libraries')
            .selectAll('libraries')
            .orderBy('createdAt', 'asc')
            .$if(!withDeleted, (qb) => qb.where('libraries.deletedAt', 'is', null))
            .execute();
    }
    getAllDeleted() {
        return this.db
            .selectFrom('libraries')
            .selectAll('libraries')
            .where('libraries.deletedAt', 'is not', null)
            .orderBy('createdAt', 'asc')
            .execute();
    }
    create(library) {
        return this.db.insertInto('libraries').values(library).returningAll().executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('libraries').where('libraries.id', '=', id).execute();
    }
    async softDelete(id) {
        await this.db.updateTable('libraries').set({ deletedAt: new Date() }).where('libraries.id', '=', id).execute();
    }
    update(id, library) {
        return this.db
            .updateTable('libraries')
            .set(library)
            .where('libraries.id', '=', id)
            .returningAll()
            .executeTakeFirstOrThrow();
    }
    async getStatistics(id) {
        const stats = await this.db
            .selectFrom('libraries')
            .innerJoin('assets', 'assets.libraryId', 'libraries.id')
            .leftJoin('exif', 'exif.assetId', 'assets.id')
            .select((eb) => eb.fn
            .countAll()
            .filterWhere((eb) => eb.and([eb('assets.type', '=', enum_1.AssetType.IMAGE), eb('assets.isVisible', '=', true)]))
            .as('photos'))
            .select((eb) => eb.fn
            .countAll()
            .filterWhere((eb) => eb.and([eb('assets.type', '=', enum_1.AssetType.VIDEO), eb('assets.isVisible', '=', true)]))
            .as('videos'))
            .select((eb) => eb.fn.coalesce((eb) => eb.fn.sum('exif.fileSizeInByte'), eb.val(0)).as('usage'))
            .groupBy('libraries.id')
            .where('libraries.id', '=', id)
            .executeTakeFirst();
        if (!stats) {
            const zero = (0, kysely_1.sql) `0::int`;
            return this.db
                .selectFrom('libraries')
                .select(zero.as('photos'))
                .select(zero.as('videos'))
                .select(zero.as('usage'))
                .select(zero.as('total'))
                .where('libraries.id', '=', id)
                .executeTakeFirst();
        }
        return {
            photos: stats.photos,
            videos: stats.videos,
            usage: stats.usage,
            total: stats.photos + stats.videos,
        };
    }
    streamAssetIds(libraryId) {
        return this.db.selectFrom('assets').select(['id']).where('libraryId', '=', libraryId).stream();
    }
};
exports.LibraryRepository = LibraryRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], LibraryRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], LibraryRepository.prototype, "getAll", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], LibraryRepository.prototype, "getAllDeleted", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], LibraryRepository.prototype, "getStatistics", null);
exports.LibraryRepository = LibraryRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], LibraryRepository);
//# sourceMappingURL=library.repository.js.map