import { Insertable, Kysely, Updateable } from 'kysely';
import { DB, Libraries } from 'src/db';
import { LibraryStatsResponseDto } from 'src/dtos/library.dto';
export declare enum AssetSyncResult {
    DO_NOTHING = 0,
    UPDATE = 1,
    OFFLINE = 2,
    CHECK_OFFLINE = 3
}
export declare class LibraryRepository {
    private db;
    constructor(db: Kysely<DB>);
    get(id: string, withDeleted?: boolean): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        exclusionPatterns: string[];
        importPaths: string[];
        refreshedAt: Date | null;
    } | undefined>;
    getAll(withDeleted?: boolean): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        exclusionPatterns: string[];
        importPaths: string[];
        refreshedAt: Date | null;
    }[]>;
    getAllDeleted(): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        exclusionPatterns: string[];
        importPaths: string[];
        refreshedAt: Date | null;
    }[]>;
    create(library: Insertable<Libraries>): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        exclusionPatterns: string[];
        importPaths: string[];
        refreshedAt: Date | null;
    }>;
    delete(id: string): Promise<void>;
    softDelete(id: string): Promise<void>;
    update(id: string, library: Updateable<Libraries>): Promise<{
        name: string;
        id: string;
        updateId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        ownerId: string;
        createdAt: Date;
        exclusionPatterns: string[];
        importPaths: string[];
        refreshedAt: Date | null;
    }>;
    getStatistics(id: string): Promise<LibraryStatsResponseDto | undefined>;
    streamAssetIds(libraryId: string): AsyncIterableIterator<{
        id: string;
    }>;
}
