import { ModuleRef } from '@nestjs/core';
import { OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit } from '@nestjs/websockets';
import { ClassConstructor } from 'class-transformer';
import { Server, Socket } from 'socket.io';
import { SystemConfig } from 'src/config';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { ReleaseNotification, ServerVersionResponseDto } from 'src/dtos/server.dto';
import { QueueName } from 'src/enum';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { JobItem } from 'src/types';
type EventMap = {
    'app.bootstrap': [];
    'app.shutdown': [];
    'config.init': [{
        newConfig: SystemConfig;
    }];
    'config.update': [
        {
            newConfig: SystemConfig;
            oldConfig: SystemConfig;
        }
    ];
    'config.validate': [{
        newConfig: SystemConfig;
        oldConfig: SystemConfig;
    }];
    'album.update': [{
        id: string;
        recipientIds: string[];
    }];
    'album.invite': [{
        id: string;
        userId: string;
    }];
    'asset.tag': [{
        assetId: string;
    }];
    'asset.untag': [{
        assetId: string;
    }];
    'asset.hide': [{
        assetId: string;
        userId: string;
    }];
    'asset.show': [{
        assetId: string;
        userId: string;
    }];
    'asset.trash': [{
        assetId: string;
        userId: string;
    }];
    'asset.delete': [{
        assetId: string;
        userId: string;
    }];
    'assets.trash': [{
        assetIds: string[];
        userId: string;
    }];
    'assets.delete': [{
        assetIds: string[];
        userId: string;
    }];
    'assets.restore': [{
        assetIds: string[];
        userId: string;
    }];
    'job.start': [QueueName, JobItem];
    'session.delete': [{
        sessionId: string;
    }];
    'stack.create': [{
        stackId: string;
        userId: string;
    }];
    'stack.update': [{
        stackId: string;
        userId: string;
    }];
    'stack.delete': [{
        stackId: string;
        userId: string;
    }];
    'stacks.delete': [{
        stackIds: string[];
        userId: string;
    }];
    'user.signup': [{
        notify: boolean;
        id: string;
        tempPassword?: string;
    }];
    'websocket.connect': [{
        userId: string;
    }];
};
export declare const serverEvents: readonly ["config.update"];
export type ServerEvents = (typeof serverEvents)[number];
export type EmitEvent = keyof EventMap;
export type EmitHandler<T extends EmitEvent> = (...args: ArgsOf<T>) => Promise<void> | void;
export type ArgOf<T extends EmitEvent> = EventMap[T][0];
export type ArgsOf<T extends EmitEvent> = EventMap[T];
export interface ClientEventMap {
    on_upload_success: [AssetResponseDto];
    on_user_delete: [string];
    on_asset_delete: [string];
    on_asset_trash: [string[]];
    on_asset_update: [AssetResponseDto];
    on_asset_hidden: [string];
    on_asset_restore: [string[]];
    on_asset_stack_update: string[];
    on_person_thumbnail: [string];
    on_server_version: [ServerVersionResponseDto];
    on_config_update: [];
    on_new_release: [ReleaseNotification];
    on_session_delete: [string];
}
export type EventItem<T extends EmitEvent> = {
    event: T;
    handler: EmitHandler<T>;
    server: boolean;
};
export type AuthFn = (client: Socket) => Promise<AuthDto>;
export declare class EventRepository implements OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit {
    private moduleRef;
    private configRepository;
    private logger;
    private emitHandlers;
    private authFn?;
    private server?;
    constructor(moduleRef: ModuleRef, configRepository: ConfigRepository, logger: LoggingRepository);
    setup({ services }: {
        services: ClassConstructor<unknown>[];
    }): void;
    afterInit(server: Server): void;
    handleConnection(client: Socket): Promise<void>;
    handleDisconnect(client: Socket): Promise<void>;
    private addHandler;
    emit<T extends EmitEvent>(event: T, ...args: ArgsOf<T>): Promise<void>;
    private onEvent;
    clientSend<T extends keyof ClientEventMap>(event: T, room: string, ...data: ClientEventMap[T]): void;
    clientBroadcast<T extends keyof ClientEventMap>(event: T, ...data: ClientEventMap[T]): void;
    serverSend<T extends ServerEvents>(event: T, ...args: ArgsOf<T>): void;
    setAuthFn(fn: (client: Socket) => Promise<AuthDto>): void;
    private authenticate;
}
export {};
