"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var EmailRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailRepository = exports.EmailTemplate = void 0;
const common_1 = require("@nestjs/common");
const render_1 = require("@react-email/render");
const nodemailer_1 = require("nodemailer");
const react_1 = __importDefault(require("react"));
const album_invite_email_1 = require("../emails/album-invite.email");
const album_update_email_1 = require("../emails/album-update.email");
const test_email_1 = require("../emails/test.email");
const welcome_email_1 = require("../emails/welcome.email");
const logging_repository_1 = require("./logging.repository");
var EmailTemplate;
(function (EmailTemplate) {
    EmailTemplate["TEST_EMAIL"] = "test";
    EmailTemplate["WELCOME"] = "welcome";
    EmailTemplate["RESET_PASSWORD"] = "reset-password";
    EmailTemplate["ALBUM_INVITE"] = "album-invite";
    EmailTemplate["ALBUM_UPDATE"] = "album-update";
})(EmailTemplate || (exports.EmailTemplate = EmailTemplate = {}));
let EmailRepository = EmailRepository_1 = class EmailRepository {
    logger;
    constructor(logger) {
        this.logger = logger;
        this.logger.setContext(EmailRepository_1.name);
    }
    verifySmtp(options) {
        const transport = this.createTransport(options);
        try {
            return transport.verify();
        }
        finally {
            transport.close();
        }
    }
    async renderEmail(request) {
        const component = this.render(request);
        const html = await (0, render_1.render)(component, { pretty: false });
        const text = await (0, render_1.render)(component, { plainText: true });
        return { html, text };
    }
    sendEmail({ to, from, subject, html, text, smtp, imageAttachments }) {
        this.logger.debug(`Sending email to ${to} with subject: ${subject}`);
        const transport = this.createTransport(smtp);
        const attachments = imageAttachments?.map((attachment) => ({
            filename: attachment.filename,
            path: attachment.path,
            cid: attachment.cid,
        }));
        try {
            return transport.sendMail({ to, from, subject, html, text, attachments });
        }
        finally {
            transport.close();
        }
    }
    render({ template, data, customTemplate }) {
        switch (template) {
            case EmailTemplate.TEST_EMAIL: {
                return react_1.default.createElement(test_email_1.TestEmail, { ...data, customTemplate });
            }
            case EmailTemplate.WELCOME: {
                return react_1.default.createElement(welcome_email_1.WelcomeEmail, { ...data, customTemplate });
            }
            case EmailTemplate.ALBUM_INVITE: {
                return react_1.default.createElement(album_invite_email_1.AlbumInviteEmail, { ...data, customTemplate });
            }
            case EmailTemplate.ALBUM_UPDATE: {
                return react_1.default.createElement(album_update_email_1.AlbumUpdateEmail, { ...data, customTemplate });
            }
        }
    }
    createTransport(options) {
        return (0, nodemailer_1.createTransport)({
            host: options.host,
            port: options.port,
            tls: { rejectUnauthorized: !options.ignoreCert },
            auth: options.username || options.password
                ? {
                    user: options.username,
                    pass: options.password,
                }
                : undefined,
            connectionTimeout: 5000,
        });
    }
};
exports.EmailRepository = EmailRepository;
exports.EmailRepository = EmailRepository = EmailRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository])
], EmailRepository);
//# sourceMappingURL=email.repository.js.map