import { Kysely } from 'kysely';
import { DB } from 'src/db';
import { DatabaseExtension, DatabaseLock, VectorIndex } from 'src/enum';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { ExtensionVersion, VectorExtension, VectorUpdateResult } from 'src/types';
export declare class DatabaseRepository {
    private db;
    private logger;
    private configRepository;
    private vectorExtension;
    private readonly asyncLock;
    constructor(db: Kysely<DB>, logger: LoggingRepository, configRepository: ConfigRepository);
    shutdown(): Promise<void>;
    getExtensionVersion(extension: DatabaseExtension): Promise<ExtensionVersion>;
    getExtensionVersionRange(extension: VectorExtension): string;
    getPostgresVersion(): Promise<string>;
    getPostgresVersionRange(): string;
    createExtension(extension: DatabaseExtension): Promise<void>;
    updateVectorExtension(extension: VectorExtension, targetVersion?: string): Promise<VectorUpdateResult>;
    reindex(index: VectorIndex): Promise<void>;
    shouldReindex(name: VectorIndex): Promise<boolean>;
    private setSearchPath;
    private setExtVersion;
    private getIndexTable;
    private updateVectorsSchema;
    private getDimSize;
    runMigrations(options?: {
        transaction?: 'all' | 'none' | 'each';
    }): Promise<void>;
    withLock<R>(lock: DatabaseLock, callback: () => Promise<R>): Promise<R>;
    tryLock(lock: DatabaseLock): Promise<boolean>;
    isBusy(lock: DatabaseLock): boolean;
    wait(lock: DatabaseLock): Promise<void>;
    private acquireLock;
    private acquireTryLock;
    private releaseLock;
}
