export declare class CryptoRepository {
    randomUUID(): string;
    randomBytes(size: number): Buffer<ArrayBufferLike>;
    hashBcrypt(data: string | Buffer, saltOrRounds: string | number): Promise<string>;
    compareBcrypt(data: string | Buffer, encrypted: string): boolean;
    hashSha256(value: string): string;
    verifySha256(value: string, encryptedValue: string, publicKey: string): boolean;
    hashSha1(value: string | Buffer): Buffer;
    hashFile(filepath: string | Buffer): Promise<Buffer>;
    newPassword(bytes: number): string;
}
