"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuditRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
let AuditRepository = class AuditRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async getAfter(since, options) {
        const records = await this.db
            .selectFrom('audit')
            .where('audit.createdAt', '>', since)
            .$if(!!options.action, (qb) => qb.where('audit.action', '=', options.action))
            .$if(!!options.entityType, (qb) => qb.where('audit.entityType', '=', options.entityType))
            .where('audit.ownerId', 'in', options.userIds)
            .distinctOn(['audit.entityId', 'audit.entityType'])
            .orderBy(['audit.entityId desc', 'audit.entityType desc', 'audit.createdAt desc'])
            .select('audit.entityId')
            .execute();
        return records.map(({ entityId }) => entityId);
    }
    async removeBefore(before) {
        await this.db.deleteFrom('audit').where('createdAt', '<', before).execute();
    }
};
exports.AuditRepository = AuditRepository;
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            decorators_1.DummyValue.DATE,
            { action: enum_1.DatabaseAction.CREATE, entityType: enum_1.EntityType.ASSET, userIds: [decorators_1.DummyValue.UUID] },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Date, Object]),
    __metadata("design:returntype", Promise)
], AuditRepository.prototype, "getAfter", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.DATE] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Date]),
    __metadata("design:returntype", Promise)
], AuditRepository.prototype, "removeBefore", null);
exports.AuditRepository = AuditRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AuditRepository);
//# sourceMappingURL=audit.repository.js.map